/******************************************************************************
 *
 *  Copyright 2018 ASAHI KASEI MICRODEVICES CORPORATION, Japan
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 ******************************************************************************/
#include <mbed.h>
#include "my-ble-definition.h"

/** @brief Initialize device.
 * @return MY_SUCCESS when device is successfully initialized.
 * @return Other when device is not initialized.
 */
uint32_t my_ble_init(void) {
    DPRINTF("my init\r\n");
    return MY_SUCCESS;
}

/** @brief This function is called when timer period is elapsed.
 * The timer interval is defined as #MY_TIMER_INTERVAL.
 */
void my_ble_timer(void) {
    /* get current time
     * this time is elapsed time since the board boots up.
     */
    uint32_t tm = (uint32_t)time(NULL);

    /** send data to BLE module */
    MY_BLE->update_data1(tm);

    DPRINTF("my timer (%d)\r\n", tm);
}

/** @brief This function is called when INT1 pin changes
 * from LOW to HIGH. In case of BUTTON1, the button 1 is released.
 */
void my_ble_int1_rise(void) {
    /* do something */
    DPRINTF("my int1 rise\r\n");
}

/** @brief This function is called when INT1 pin changes
 * from HIGH to LOW. In case of BUTTON1, the button 1 is pressed.
 */
void my_ble_int1_fall(void) {
    /* do something */
    DPRINTF("my int1 fall\r\n");
}

void my_ble_int2_rise(void) {
    /* do something */
    DPRINTF("my int2 rise\r\n");
}

void my_ble_int2_fall(void) {
    /* do something */
    DPRINTF("my int2 fall\r\n");
}

void my_ble_received(const uint32_t data) {
    /* do something */
    DPRINTF("Data received (%d)\r\n", data);
}
