/******************************************************************************
 *
 *  Copyright 2018 ASAHI KASEI MICRODEVICES CORPORATION, Japan
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 ******************************************************************************/
#pragma once
#include <mbed.h>

/** user definition */
#include "my-ble-config.h"

enum MY_LED {
    MY_LED1,
    MY_LED2,
    SYSST_LED,
    BLEST_LED
};

enum MY_INTERRUPT {
    MY_INT1_RISE,
    MY_INT1_FALL,
    MY_INT2_RISE,
    MY_INT2_FALL
};

extern I2C my_i2c;
extern SPI my_spi;
extern DigitalOut my_spi_cs;
extern DigitalOut my_gpio1;
extern DigitalOut my_gpio2;
extern AnalogIn my_ad1;
extern AnalogIn my_ad2;

/** Debug macro
 */
#ifdef NDEBUG
#define DPRINTF(...)
#else
extern Serial debug_uart;
#define DPRINTF(...) debug_uart.printf(__VA_ARGS__)
#endif

void set_led(MY_LED led, bool on);
void set_isr(MY_INTERRUPT interrupt, Callback<void()> fp);
