/*INSTITUTO POLITÉCNICO NACIONAL
  ESCUELA SUPERIOR DE INGENIERÍA MECÁNICA Y ELÉCTRICA
  INGENIERÍA ELÉCTRICA
  SPWM & THPWM
  RIVERA GUILLEN GUSTAVO
  2016*/
#include "mbed.h"

//Number of dutycycle steps for output wave
#define SINE_STEPS        32
//Frequency of output sine in Hz
#define SINE_OUT_FREQ     60

//Constants to compute the sine waveform
#define PI                            3.14159265359f
#define SINE_STEPS_RAD               (2.0f * PI / (float)SINE_STEPS)
#define ANGLE_RAD_PHASE_A             0.0f
#define ANGLE_RAD_PHASE_B             2.09439510239f
#define ANGLE_RAD_PHASE_C             4.18879020479f
#define CONST_A                       1.15470053838f
#define CONST_B                       0.19245008973f

//Frequency of Pulse Width Modulated signal in Hz
#define PWM_FREQ          5000

//Comunication Serial to PC
Serial pc(USBTX, USBRX);

//PWM pin
PwmOut Pwm_Phase_A (PTB0);
PwmOut Pwm_Phase_B (PTB1);
PwmOut Pwm_Phase_C (PTB2);

//Heartbeat LED
DigitalOut Led_sine(LED1,1);
DigitalOut Led_3rd (LED2,1);

//Tickers to update the PWM dutycycle
Ticker pwm_ticker1;
Ticker pwm_ticker2;

//Table to generate the sine waveform using dutycycles
float sine_duty_A[SINE_STEPS];
float sine_duty_B[SINE_STEPS];
float sine_duty_C[SINE_STEPS];

float sine_duty_3rd_harmonic_A[SINE_STEPS];
float sine_duty_3rd_harmonic_B[SINE_STEPS];
float sine_duty_3rd_harmonic_C[SINE_STEPS];


//Ticker calls this fucntion to update the PWM dutycycle

void pwm_sinusoidal_duty_updater()
{
    static int idx=0;

    Pwm_Phase_A.write(sine_duty_A[idx]);  // Set the dutycycle % to next value in array
    Pwm_Phase_B.write(sine_duty_B[idx]);
    Pwm_Phase_C.write(sine_duty_C[idx]);

    idx++;                         // Increment the idx
    if (idx == SINE_STEPS) idx=0;  // Reset the idx when teh end has been reached

}

//Ticker calls this fucntion to update the PWM dutycycle
void pwm_sinusoidal_3rd_harmonic_duty_updater()
{

    static int idx=0;

    Pwm_Phase_A.write(sine_duty_3rd_harmonic_A[idx]);   // Set the dutycycle % to next value in array
    Pwm_Phase_B.write(sine_duty_3rd_harmonic_B[idx]);
    Pwm_Phase_C.write(sine_duty_3rd_harmonic_C[idx]);

    idx++;                         // Increment the idx
    if (idx == SINE_STEPS) idx=0;  // Reset the idx when teh end has been reached

}

//main principal
int main()
{
//Comunication Serial speed
    pc.baud(9600);

//Local variables
    int i;
    int k=0;

//Caculate to generate the sine waveform using dutycycles
    for (i=0; i<SINE_STEPS; i++) 
    {
        //Phase A
       

        sine_duty_A[i] = ( sin(i * SINE_STEPS_RAD+ANGLE_RAD_PHASE_A) + 1.0f ) / 2.0f;  
        // convert sine (-1.0 .. +1.0) into dutycycle (0.0 .. 1.0)

        //Phase B

        sine_duty_B[i] = ( sin(i * SINE_STEPS_RAD+ANGLE_RAD_PHASE_B) + 1.0f ) / 2.0f;  
        // convert sine (-1.0 .. +1.0) into dutycycle (0.0 .. 1.0)

        //Phase C

        sine_duty_C[i] = ( sin(i * SINE_STEPS_RAD+ANGLE_RAD_PHASE_C) + 1.0f ) / 2.0f;  
        // convert sine (-1.0 .. +1.0) into dutycycle (0.0 .. 1.0)

    }

    for (i=0; i<SINE_STEPS; i++) 
    {
        //Phase A
        sine_duty_3rd_harmonic_A[i] = (( CONST_A*sin(i * SINE_STEPS_RAD+ANGLE_RAD_PHASE_A)+CONST_B*sin(3.0f*i * SINE_STEPS_RAD)) + 1.0f ) / 2.0f;  
        // convert sine (-1.0 .. +1.0) into dutycycle (0.0 .. 1.0)

        //Phase B

        sine_duty_3rd_harmonic_B[i] = (( CONST_A*sin(i * SINE_STEPS_RAD+ANGLE_RAD_PHASE_B)+CONST_B*sin(3.0f*i * SINE_STEPS_RAD)) + 1.0f ) / 2.0f;  
        // convert sine (-1.0 .. +1.0) into dutycycle (0.0 .. 1.0)

        //Pahse C

        sine_duty_3rd_harmonic_C[i] = (( CONST_A*sin(i * SINE_STEPS_RAD+ANGLE_RAD_PHASE_C)+CONST_B*sin(3.0f*i * SINE_STEPS_RAD)) + 1.0f ) / 2.0f;  
        // convert sine (-1.0 .. +1.0) into dutycycle (0.0 .. 1.0)
    }

    // Set PWM frequency in Hz
    Pwm_Phase_A.period( 1.0f / (float) PWM_FREQ);
    Pwm_Phase_B.period( 1.0f / (float) PWM_FREQ);
    Pwm_Phase_C.period( 1.0f / (float) PWM_FREQ);

    while(1)

    {

        pc.printf("\rElige una opcion\r\n");
        pc.printf("1. SPWM\r\n");
        pc.printf("2. THPWM\r\n");
        int Menu=pc.getc();

        switch (Menu) 
        {

            case '1':

                //Indicator Led
                Led_sine=0;
                Led_3rd=1;



                // Init the Ticker to call the dutycyle updater at the required interval
                // The update should be at (SINE_STEPS * SINE_OUT_FREQ)
                pwm_ticker1.attach(&pwm_sinusoidal_duty_updater, 1.0f / (float)(SINE_STEPS * SINE_OUT_FREQ));

                pc.printf("cycle duty= %3.3f\t%3.3f\t%3.3f\r\n", Pwm_Phase_A.read()*100,Pwm_Phase_B.read()*100,Pwm_Phase_C.read()*100);


                break;


            case '2':
                Led_3rd=0;
                Led_sine=1;

                // Init the Ticker to call the dutycyle updater at the required interval
                // The update should be at (SINE_STEPS * SINE_OUT_FREQ)
                pwm_ticker2.attach(&pwm_sinusoidal_3rd_harmonic_duty_updater, 1.0f / (float)(SINE_STEPS * SINE_OUT_FREQ));

                pc.printf("cycle duty_3rd= %3.3f\t%3.3f\t%3.3f\r\n", Pwm_Phase_A.read()*100,Pwm_Phase_B.read()*100,Pwm_Phase_C.read()*100);

                break;

                //Default menu
            default:
                pc.printf("Invalido \r\n");
                Led_3rd=1;
                Led_sine=1;
                k=3;
        }

        //Exit to menu
        if(k>2) {
            pc.printf("End\r\n");
            break;
        }

    }

}