#include "mbed.h"

Serial pc(PA_2, PA_3);
Serial reader(PB_6, PB_7);
InterruptIn Green(PB_0);
DigitalIn CTS(PB_1);
int TXBsize = 1;
char TXB[16];    
//for init RFID
uint8_t READRFID = 0b01010010;
uint8_t WRITEEEPROM = 0b01010000;
uint8_t POLLING = 0x1;
uint8_t POLLINGADDRESS = 0;
uint8_t RFIDTYPEADDRESS = 0x3;
uint8_t RFIDTYPE = 0x0;
uint8_t ADDRESS = 2;
uint8_t ADDRESSMAX = 40;  
uint8_t KEY = 0;
bool FINDINGUID = 0;
bool UIDFOUND = 0;  
bool SENDSUCCESS = 0;
bool UIDTRIED = 0;
bool inword = 0;   //avoid sending dummy bits, flag. etc..
bool spoken = 0;
char speak [256];
uint8_t speaklength=0;  //length of words to be send
uint8_t UID[8];
 bool nextread = 1;   //read next address or stop
void readerRX() {  //will enter this through interrupt, recieving data from rfid mdule
   if(FINDINGUID == 1)   //only for multiple tag read, not used in this project
   {UID[0]=reader.getc();
    UID[1]=reader.getc();
    UID[2]=reader.getc();
    UID[3]=reader.getc();
    UID[4]=reader.getc();
    UID[5]=reader.getc();
    UID[6]=reader.getc();
    UID[7]=reader.getc();
 
    pc.printf("%d %d %d %d %d %d %d %d", UID[7],UID[6], UID[5], UID[4], UID[3], UID[2], UID[1], UID[0]);
    UIDFOUND = 1;
    FINDINGUID = 0;
   }
   else
   {
    char tmp = reader.getc();
    if(tmp == '@')
     {inword = 1;}
    else if(tmp == ';')
     {inword = 0;}
    if(inword == 1 && tmp != '@' && tmp != ';' && tmp < 0b10000000) //to avoid non char character to be sent
       {spoken = 0;
        speak[speaklength]=tmp;
        speaklength++;
       }
   }
   
}

void GreenIRQ() { //enter through interrupt, send command and read address to the RFID chips, send words to central MCU.
     if(Green == 0 && nextread == 1)
     {bool sent = 0;
       uint8_t TXBused = 0; 
     TXB[0]=READRFID;
      TXB[1]=KEY;
      TXB[2]=ADDRESS;
      TXBsize = 3;
   
    if(SENDSUCCESS == 1 && TXB[0] == READRFID) //synthesize the command
      {ADDRESS=ADDRESS+4;  
      SENDSUCCESS = 0;
      TXBsize = 3;
      if(ADDRESS > ADDRESSMAX)
      {ADDRESS = 2;
      nextread = 0;
       }
    /*  if(ADDRESS == 0)
       {KEY++;
         if(KEY == 0b00100000)
         {KEY = 0b10000000;}
         else if(KEY == 0b10100000)
         {KEY = 0b00000000;}
         pc.printf("%d",KEY);
        } */
      TXB[1]=ADDRESS;
      TXB[2]=KEY;
      }
      
    
        // Time keeping
    while (TXBused<TXBsize){
        if (CTS == 0 && sent == 0){
            reader.putc(TXB[TXBused]);  //send the command to RFID chip when CTS=0
            TXBused++;
           // sent = 1;
      }
      else if(CTS == 1)
      {sent = 0;
       }
     SENDSUCCESS = 1;
      }
      while(CTS == 0);
      
     }
    else if(Green == 1)
     {nextread = 1;
      ADDRESS = 2;
      if(spoken == 0)
      {uint8_t tmpsize = speaklength+1;
       if(speaklength == 255)
       {tmpsize=255;}
       speak[tmpsize]='!';  //Tell the Central MCU thst the word are finished.
       for(int i=0; i<=tmpsize; i++)  // sent the composed mesaage to the central MCU
       {pc.putc(speak[i]);}      
       speaklength = 0;
       spoken = 1;
      }
     }
    if(spoken == 0 && nextread == 0)
      {uint8_t tmpsize = speaklength+1;
       if(speaklength == 255)
       {tmpsize=255;}
       speak[tmpsize]='!';
       for(int i=0; i<=tmpsize; i++)
       {pc.putc(speak[i]);}
       speaklength = 0;
       spoken = 1;
      }
}


void initRFID()  //program the EEPROM of RFID chip to set it to the correct mode
{   bool sent = 0;

while (sent ==0 )
    { if(CTS == 0)
      {TXBsize = 3;
       reader.putc(WRITEEEPROM);
       reader.putc(RFIDTYPEADDRESS);
       reader.putc(RFIDTYPE);
       sent = 1;
      }
     }
while (CTS == 0){}
while (CTS == 1){}
sent = 0;
while (sent ==0 )
    { if(CTS == 0)
      {TXBsize = 3;
       reader.putc(WRITEEEPROM);
       reader.putc(POLLINGADDRESS);
       reader.putc(POLLING);
       sent = 1;
      }
     }
   
  }


int main() {
    
    pc.baud(9600);
    reader.baud(9600);
   initRFID();
   reader.attach(&readerRX,Serial::RxIrq);
    Green.fall(&GreenIRQ);  // attach the address of the flip function to the rising edge
    while(true)
    {if(Green == 0)
     { wait(0.05);
      GreenIRQ();}
   }
    
}
