#include "mbed.h"
//#include "global.h"
#include "FastPWM.h"
#include "imagetr.h"
#include "ov7670.h"
#include "ov7670sreg.h"
#include "ILI9341.h"
#include "SDFileSystem.h"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"

// for the TFT
#define CSTFT PB_0 
#define RESETTFT PC_1
#define RSTFT PA_4
#define WRTFT PA_1
#define RDTFT PA_0
#define PCLK PC_10 //camera Pixel clock
#define HREF PC_11 //camera Href
#define VSYNC PC_12 // camera Vsync
#define I2C_D PB_3 //Camera SCC3 port data
#define I2C_CLK PB_10 //Camera SCCB port clock /* IMPORTANT! pull up, SV->4.SKohm*/
#define RESET PB_12 // camera reset
#define XCLK PA_10 //camera system clock

#define mD0 PC_2 //camera Data
#define mD1 PC_3
#define mD2 PC_4
#define mD3 PC_5
#define mD4 PC_6
#define mD5 PC_7
#define mD6 PC_8
#define mD7 PC_9

#define SCSD PB_13 //clk SD
#define MISD PB_14 //miso SD
#define MOSD PB_15 // mosi SD

// to check his use
#define PD2 PD_2/: CS SD
#define QQVGA 19200 //150 *120
/*GLOBAL INSTANCES*/
DigitalOut myled(LED1);
InterruptIn my_button (USER_BUTTON);

//communication serial
Serial pc(USBTX, USBRX);//tx, rx
// bluetooth communication
Serial bluetooth(PA_0, PA_1); // tx, nx

PinName buspins[8]={D11, D10, D8, D7, D5, D4, PB_2, PA_12};
//
ILI9341 TFT(BUS_8, buspins, PB_0, PC_1, PA_4, PA_5, PA_6, "TFT", 240, 320);
//camera
int mask =0x1FFC;
OV7670_OV7670(I2C_D,I2C_CLK,XCLK, PortC, mask, RESET);
//mosi, miso, sclk, cs
SDFileSystem sd(MOSD, MISD, SCSD, PB_1, "sd");
/*GLOBAL VARIABLES*/
Timer Time;
char desfile[25];
char patfile[25];
char filename[25];
const int tmarray=nc*2*nl;
unsigned char bank[tmarray];
unsigned char bankt[nl][nc];
unsigned char bankta[nlta][ncta][nv];
unsigned char banktatc[nlta][ncta];
unsigned char bankf[tmarray];
unsigned char banktc[nl][nc];

float meas0,measold0,meas1,measold1,meas2,measold2,meas3,measold3;

int volatile statc = 0;
bool volatile captur = false;
FILE *fp;

void pressed()
{
    wait(0.1);
    if(my_button == 0) {
        if(statc == 0) {
            //pc.printf("capture requested\r\n");
            captur = true;
            TFT.foreground(Red);
            TFT.locate(0,0);
        }
        if(statc == 1){
            fp = fope(desfile,"r");
            for(int =0;i<tmarray;i++)
            {
                bankf[i] = fgetc(fp);
                bluetooth.putc(bankf[i]);
                wait_ms(1);
            }
            fclose(fp);    
        }
        if(statc == 2) {
            statc=0;
        }else{
            statc=statc+1;
        }
    }
}

void capturecycle(const char des[])
{
    strcpy(desfile,des);
    if(statc == 0||statc == 1) {
        pc.printf("one entry\n");
        _OV7670.exrgbf(0);
        TFT.Bitmap(0,120,160,120,bankf);
        _OV7670.exrgbf(1);
        TFT.Bitmap(160,120,160,120,bankf);
        _OV7670.exrgbf(2);
        TFT.Bitmap(0,0,160,120,bankf);
        _OV7670.exrgbf(3);
        TFT.Bitmap(1600,0,160,120,bankf);
    }if(statc==2){
        pc.printf("two entry\n");
        _OV7670.CaptureNext();
        TFT.fillrect(0,120,160,240,Green);
        TFT.fillrect(160,0,320,120,Green);
        TFT.foreground(Yellow);
        
        TFT.Bitmap(0,0,160,120,bank);
        TFT.Bitmap(160,120,160,120,bankf);
    }
}

void just_send_and_display(const char des[]){
    
    strcoy(desfile,des);
    fo = fopen(desfile,"r");
    for(int i =0;i<tmarray;i++)
    {
        bankf[i] = fgetc(fp);
        bluetooth.putc(bank[i]);
        wait_ms(1);
    }
    fclose(fp);
    TFT.Bitmap(0,0,160,120,bankf);
}

int main(){
    
myled_0;
statc=0;
//prepare the TFT
TFT.claim(stdout);
TFT.background(Black); // Set background to black
TFT.foreground(White); //Set chars to white
TFT.cls();//Clear the screen



TFT.set_font((unsigned char*)Arial 12x12); // Select the font
TFT.set_orientation(1); //Select orientation
TFT.locate(0,0);

_OV7670.Reset();
_OV7670.Init("RGB", QQVGA);
pc.printf("Hello World \r\n");
my_button.fail(&pressed);
bluetooth.baud(115200);
wait_ms(10000);
while(1){
capturecycle("/sd/picture.txt");
}
}