
// MBED Headers
#include "mbed.h"
#include "EthernetInterface.h"

DigitalOut led1(LED1);  // green
DigitalOut led2(LED2);  // blue
DigitalOut led3(LED3);  // red

Serial logger(SERIAL_TX, SERIAL_RX);

EthernetInterface   gEth;
#define UDP_PORT            3865
#define UDP_BUFFER_SIZE     500

UDPSocket           _socket;
UDPSocket           _socketSender;

char                in_buffer[UDP_BUFFER_SIZE];


// -----------------------------------------------------------
// 
// -----------------------------------------------------------
void terminal_error_state( void )
{
    led1=0;
    led2=0;
    led3=0;
    logger.printf("\r\n\r\nJUST TO BE CLEAR - THIS IS BAD BAD NEWS !!! \r\n");
    logger.printf("\r\n\r\n---- WAITING FOR THE WATCHDOG TO RESET US ---- \r\n");
    while( 1 )
        {
        led1 = !led1;
        led2 = !led2;
        led3 = !led3;
        wait(0.3);
        }
}


// -----------------------------------------------------------
// 
// -----------------------------------------------------------
static bool DeviceConnect()
{
    int retries = 10;
    int rc = 0;
    
    while (retries--) 
        {
        rc = gEth.connect();
        if (rc == 0) {
            return true;
            }
        else
            {
            logger.printf("Connecting... ERR %d\r\n", rc);
            }
        }
    
    logger.printf("Connecting... FAILED\r\n");
    return false;
}

// -----------------------------------------------------------
// 
// -----------------------------------------------------------
static bool DeviceEthStartup()
{
    int rc = 0;
    
    // get ethernet up !
    if( !DeviceConnect() ) terminal_error_state();
    
    // Output the network address
    const char *ip = gEth.get_ip_address();
    const char *netmask = gEth.get_netmask();
    const char *gateway = gEth.get_gateway();
    logger.printf("IP address: %s\r\n", ip ? ip : "None");
    logger.printf("Netmask: %s\r\n", netmask ? netmask : "None");
    logger.printf("Gateway: %s\r\n", gateway ? gateway : "None");
    
    // setup a listener
    _socket.set_blocking(true);
    _socket.set_timeout(3000);
    
    // open the socket
    rc = _socket.open((NetworkInterface*)&gEth);
    if( rc != 0)
        {
        logger.printf("UDPSocket RECEIVER OPEN ERROR   (rc=%d)\r\n", rc);
        terminal_error_state();
        }
    
    // bind the port
    rc = _socket.bind(UDP_PORT);
    logger.printf("Binding port %d\r\n", UDP_PORT);
    if( rc != 0)
        {
        logger.printf("UDPSocket BIND ERROR   (rc=%d)\r\n", rc);
        terminal_error_state();
        }
    
    // open the sender socket
    //rc = _socketSender.open((NetworkInterface*)&gEth);
    //if( rc != 0)
    //    {
    //    logger.printf("UDPSocket SENDER OPEN ERROR   (rc=%d)\r\n", rc);
    //    terminal_error_state();
    //    }
    
    return true;
}

// -----------------------------------------------------------
// 
// -----------------------------------------------------------
void SendUdPMessage(char *buffer)
{
    // send the UDP data as broadcast
    int rc = _socketSender.sendto( "255.255.255.255", UDP_PORT, (const void *)buffer, strlen( buffer ) );
    logger.printf("[SEND rc=%d] buffer[%d]\r\n%s\r\n", rc, strlen(buffer), buffer);
}

// -----------------------------------------------------------
// main() runs in its own thread in the OS
// -----------------------------------------------------------
int main() {
    
    DeviceEthStartup();
    
    while (true) {
        led1 = !led1;
        wait(0.5);
    }
}

