
// -----------------------------------------------------------
// MBED Headers
//#include "mbed.h"
//#include "string.h"
//#include "stdlib.h"

// -----------------------------------------------------------
// My Headers
#include "nihh_utils.h"

#define WHITESPACE_STR  " \f\n\r\t\v"

//******************************************************************************
// Remove whitespace characters from both ends of a copy of
//   '\0' terminated STRING and return the result.
//******************************************************************************
char * UTILS_TrimString( char *pszString, char * pszResult )
{
   
   // Dont process a NULL pointer or a blank string
   if ((pszString!=NULL) && (*pszString!='\0'))
      {
      // setup the temp string
      char *ptr = pszString;
      
      // Skip leading spaces
      while ( *ptr == ' ' )
         ++ptr;
      
      // copy the remainder of the string into the result string
      strcpy( pszResult, ptr );
      
      // make sure there is something left !
      if( *pszResult == '\0' )
         {
         // bail because theres nothing left !
         return pszResult;
         }
      else
         {
         // Move to the last character in the string
         for (ptr = pszResult; *ptr; ++ptr);
      
         // Loop through from the end of the string 
         // while the char is one of WHITESPACE_STR
         for (--ptr; strchr (WHITESPACE_STR, *ptr); --ptr)
            {
            // this char is a WHITESPACE_STR so 
            // overwrite it with the end of string char
            *ptr = '\0';
            }
         }
      }
   else
      {
      // it was a null pointer or a blank string so set the result to blank
      strcpy( pszResult, "" );
      }

  return pszResult;
}

//*******************************************************************************
// 
//*******************************************************************************
int UTILS_ParseString   (   char*   pszString,      // String to parse
                            char*   apszParms[],    // array to put parsed params into
                            int     iMaxParams,     // max number of params
                            int     iSeperator,     // 
                            int     iStrip          // trim params ? 1=yes
                        )
{
    char*   pszStr  ;   // 
    char*   pszTok  ;   // 
    int     i       ;   // 
    
    // defaults
    i       =   0           ;
    pszStr  =   pszString   ;
    
    // loop through the string
    while( (pszStr != NULL) && (i < iMaxParams) )
        {
        // store the start of the param
        pszTok = pszStr;
        
        // look for a seperator
        pszStr = strchr( pszStr, iSeperator );
        
        // are we at the end of the string !?
        if( pszStr != NULL )
            {
            // overwrite the : with a string terminator
            *pszStr = '\0';
            
            // move on a char
            pszStr++;
            }
        
        // store the pointer
        apszParms[i] = pszTok;
        
        // have we been asked to trim the params ?
        if( iStrip == 1 )
            {
            // just do a trim on it..
            UTILS_TrimString( pszTok, pszTok );
            }
        
        // move on
        i++;
        }
    
    // return the number of params we found !
    return i;
}


//*******************************************************************************
// Returns :
//      -1  check passed
//      -2  incorrect number of params
//      -3  incorrect start position
//      +?  failed validation of parameter ?    
//*******************************************************************************
int UTILS_CheckParams( const char * pszMask, int iTokens, char * pszTokens[], int iStartParam ) // , int iBlanks )
{
    int iFormatChars = strlen(pszMask);
    int i;
    int iMaskPos;
    
    // are there the correct number of params ?
    if( iFormatChars != (iTokens-iStartParam) )
        {
        //LOG_AppendToLog( LOG_I, "(UTILS_CheckParams) failed (rc=-2)\n" );
        return -2;
        }
    
    // make sure we are not trying to start checking further into the array than we have params for !!
    if( iStartParam > iTokens )
        {
        //LOG_AppendToLog( LOG_I, "(UTILS_CheckParams) failed (rc=-3)\n" );
        return -3;
        }
    
    iMaskPos = 0;
    
    // Now check each param to make sure its the correct format
    for( i=iStartParam; i<=(iFormatChars); ++i )
        {
        // if it is a lower case mask then it can NOT be blank !
        if( (int)*(pszMask+iMaskPos) > 'Z' )
            {
            // Blanks are not allowed !
            if( strlen(pszTokens[i]) == 0 )
                return i;
            }
        
        // check the data type
        switch( (int)*(pszMask+iMaskPos) )
            {
            // Integer
            case 'i':
            case 'I':
                {
                char *  psz ;   // 
                //long  l   ;   // 
                
                // defaults
                psz = NULL;
                //l = strtol( pszTokens[i], &psz, 10 );
                strtol( pszTokens[i], &psz, 10 );
                
                // if the pointer aint at the end of the string then we've got duff chars
                if( pszTokens[i] + strlen(pszTokens[i]) != psz )
                    {
                    // failed.. its a non numeric param
                    return i;
                    }
                break;
                }
            
            // Address
            case 'a':
            case 'A':
                {
                // check for a valid ip address
                char    szIP        [20]    ;   // just enough to hold a 
                char*   pszParamsIP [4]     ;   // 
                int     numParams           ;   // 
                int     rcCheckParams       ;   // param format rc
                
                // Make sure we have an ok amount of chars !
                if( strlen( pszTokens[i] ) > 15 )
                    {
                    // invalid ip address
                    return i;
                    }
                
                // take a copy of the ip address to work on
                strcpy( szIP, pszTokens[i] );
                
                // parse the ip using a dot
                numParams = UTILS_ParseString( szIP, pszParamsIP, 4, '.', PARSE_STRIP );
                
                // check for a correctly formated set of params
                // yes this is a recursive call :-) so DONT put 'a' or 'A' in this line !!!!!
                rcCheckParams = UTILS_CheckParams( "iiii", numParams, pszParamsIP, 0 );
                
                // check that the format was ok !
                if( rcCheckParams != -1 )
                    {
                    // failed :-(
                    return i;
                    }
                
                break;
                }
            
            // String
            case 's':
            case 'S':
                {
                // anything is ok..
                break;
                }
            
            // character
            case 'c':
            case 'C':
                {
                // Make sure there is only 1 char
                if( strlen(pszTokens[i]) != 1 )
                    {
                    // Error if its more than 1 char
                    return i;
                    }
                }
            }
        
        // Move onto the next mask char
        iMaskPos++;
        }
    
    // all ok :-)
    return -1;
}


//*******************************************************************************
// 
//*******************************************************************************
int UTILS_HEXtoDEC( int Pos1, int Pos2 )     // Convert 2 byte HEX to DEC
{
    //int dump;
    
    // Now convert the HEX to DEC
    
    int DECval = 0;
    
    if(Pos2 <= 57)                             // Convert Pos2 from 16 base to 10 base
        {
        DECval = DECval + (Pos2-48);
        }
    else
        {
        DECval = DECval + (Pos2-55);
        }
    
    if(Pos1 <= 57)                             // Convert Pos1 from 16 base to 10 base
        {
        DECval = DECval + 16*(Pos1-48);
        }
    else
        {
        DECval = DECval +  16*(Pos1-55);
        }
    
    return DECval;
}

//*******************************************************************************
// 
//*******************************************************************************
char* UTILS_bit_sprintf(char* pszOut, int iValue, int length)
{
    unsigned int mask = 0x01;
    int bit = 0;
    
    for( bit = length; bit >= 0; bit-- )
        {
        if ((mask << bit) & iValue)
            {
            *(pszOut+bit) = '1';
            }
        else
            {
            *(pszOut+bit) = '0';
            }
        }
    
    *(pszOut+length) = '\0';
    
    return pszOut;
}


// ==================================================================================================================
// 
// ==================================================================================================================
char *UTILS_replace_char_in_string(char *in_string, char to_search, char to_replace_with)
{
    //char *buf;
    int i=0; //,j=0;
    //char temp[50];

    while(in_string[i] !='\0')
        {
        if(in_string[i] == to_search )
            {
            //temp[j] = to_replace_with;
            in_string[i] = to_replace_with;
            //j++;
            }
        //else
            //temp[j++] = string[i++];
        i++;
        }
    
    //temp[j] = '\0';
    //buf = (char *) malloc(strlen(temp) + 1);
    //strcpy(buf,temp);
    
    // printf("%s\n",buf);
    
    //return buf;
    return in_string;
}

// ==================================================================================================================
// 
// ==================================================================================================================
char *UTILS_strip_char_in_string(char *in_string, char to_search )
{
    int i=0,j=0;
    
    while(in_string[i] !='\0')
        {
        if(in_string[i] == to_search )
            {
            ++i;
            }
        else
            {
            in_string[j] = in_string[i];
            ++i;
            ++j;
            }
        
        in_string[j] = in_string[i];
        }
    
    in_string[j] = '\0';
    
    return in_string;
}
