#include "mbed.h"
#include"PCA9685.h"
 
#define I2C_ADDR_PCA9685   (0xEE) // Device You Wish to Use Address - using i2c Address

#define WRITE              (0x00) // i2c Write bit
#define READ               (0x01) // i2c Read bit

// ----- NOTES -----
// 4.7k resistor pull up to 3.3v on SDA and SDL lines
// SCL is green on our boards
// 

Serial pc(SERIAL_TX, SERIAL_RX); //Serial Class Pin Assignments see Serial.h


PCA9685 pwm( I2C_SDA, I2C_SCL );


bool I2CScan( I2C *i2c, int Device_Adress )
{
    char ucdata_write[2];
    
    ucdata_write[0]=0;
    ucdata_write[1]=0;
    
    // try writing to the device
    if (!i2c->write((Device_Adress|WRITE), ucdata_write, 1, 0))// Check for ACK from i2c Device NB I am 'ORing' the Write Bit
        {
        // all good
        return true;
        }
    // no device found
    return false;
}


int I2CScan( I2C *i2c )
{
    short count=0;
    
    // scan all channels
    pc.printf("====================================================\n\r");
    pc.printf("I2CScan (ALL Channels)\n\r");
    for (int Device_Adress=0; Device_Adress<=0xFE; Device_Adress+=2)//Stepping in 2 Because Read/Write use LSB
        {
        if( I2CScan(i2c, Device_Adress) )
            {
            pc.printf("I2CScan: %#4x\n\r", Device_Adress );
            count++;
            }
        }
    pc.printf("%d Devices detected!\n\r",count);
    pc.printf("====================================================\n\r\n\r");
    
    return count;
}



void PCA9685_initDriver() {
    pwm.begin();
    pwm.setPWMFreq(1600);     // max frequency
    pwm.frequencyI2C(400000); //400kHz fast I2C comunication
}


int main()
{
    I2C i2c(I2C_SDA, I2C_SCL);       //I2C Class Pin Assignments see I2C.h
    
    unsigned int uifrequency=400000; //400KHz for i2c Max
    unsigned int uibaudrate=115200;
    
    // debug
    pc.baud(uibaudrate);
    pc.printf("\n\r ---- I2C Scanner ---- \n\r");
    
    // setup i2c
    i2c.frequency(uifrequency);
    pc.printf("I2C: %uKHz\n\r", uifrequency/1000);
    
    // scan
    I2CScan(&i2c);
    
    // Init the PCA9685 on the default addr
    PCA9685_initDriver();
    
    // loop led's on channel 0 and 1
    while(1)
        {
        for (int i = 0; i < 4095; i=i+24)
            {
            pwm.setPWM_ALL(4095-i,0);
            wait(0.0005);
            }
        for (int i = 4094; i > 0; i=i-24)
            {
            pwm.setPWM_ALL(4095-i,0);
            wait(0.0005);
            }
/*
        pc.printf("1.");
        for (int i = 0; i < 4095; i=i+8)
            {
            pwm.setPWM(1,4095-i,0);
            wait(0.0005);
            
            pwm.setPWM(2,i,0);
            wait(0.0005);            
            }
        
        pc.printf("2.");
        for (int i = 4094; i > 0; i=i-8)
            {
            pwm.setPWM(1,4095-i,0);
            wait(0.0005);
            
            pwm.setPWM(2,i,0);
            wait(0.0005); 
            }
        pc.printf("\n\r");
*/
        }
}

