#ifndef ADK_H_INCLUDED
#define ADK_H_INCLUDED

#include "mbed.h"
#include "USBHost.h"


#define  ADKLOG 1
#if ADKLOG
#define  LOG(...)       printf(__VA_ARGS__)
#define  Log(...)       printf(__VA_ARGS__)
#define  log(...)       printf(__VA_ARGS__)

#else
#define  LOG(...)       do {} while(0)
#define  Log(...)       do {} while(0)
#define  log(...)       do {} while(0)

#endif

#define ACCESSORY_STRING_MANUFACTURER   0
#define ACCESSORY_STRING_MODEL          1
#define ACCESSORY_STRING_DESCRIPTION    2
#define ACCESSORY_STRING_VERSION        3
#define ACCESSORY_STRING_URI            4
#define ACCESSORY_STRING_SERIAL         5

#define ACCESSORY_GET_PROTOCOL          51
#define ACCESSORY_SEND_STRING           52
#define ACCESSORY_START                 53


bool switchDevice(int device);

/** Library to allow your mbed device to communicate with the Android ADK.
  *  
  * Information about the ADK here: http://accessories.android.com/
  * 
  * Example:
  * @code
  * class DemoKit : public AndroidAccessory
  * {
  *   public:
  *     DemoKit() : AndroidAccessory    ( 3,
  *                                       3,
  *                                      "Google, Inc.",
  *                                      "DemoKit",
  *                                      "DemoKit Arduino Board",
  *                                      "1.0",
  *                                      "http://www.android.com",
  *                                      "0000000012345678") {};
  *     virtual int  callbackRead(u8 *buff, int len);
  *     virtual void setupDevice();
  *     virtual void resetDevice();
  * }
  * @endcode
  */
class AndroidAccessory {
public:

    AndroidAccessory(int rbuffsize,int wbuffsize,
                     const char* manufacturer,
                     const char *model,
                     const char *description,
                     const char *version,
                     const char *uri,
                     const char *serial
                    );
    virtual void init(int device, int configuration, int interfaceNumber); 

    virtual void resetDevice()=0;
    virtual void setupDevice()=0;
    virtual int callbackRead(u8 *buff, int len)=0;
    int write(u8 *buff, int len);
    int write() {
        return write(_writebuff,_writebuffsize);
    }
    
    void Sleep() {
        USBLoop();
    }

    void adkEnd() {
       // _initok=false;
        resetDevice();
    }; //if connection close
    bool switchDevice(int device);

    //buffer
    u8* _readbuff;
    int _readbuffsize;
    u8* _writebuff;
    int _writebuffsize;
    u8* _strbuff;//255bytes;

private:

    void sendString(int device, int index, const char *str);
    int getProtocol(int device);

    const char *manufacturer;
    const char *model;
    const char *description;
    const char *version;
    const char *uri;
    const char *serial;

    //endpoints
    int input_ep;
    int output_ep;

    int _device;
    int _configuration;
    int _interfaceNumber;

    //bool _initok;

};

extern AndroidAccessory* _adk;


#endif