// My first program: intial stage in creating a smart doorbell system.

#include "mbed.h"

// LED1 = P1.18  LED2 = P1.20  LED3 = P1.21  LED4 = P1.23
#define LED_MASK 0x00B40000
int mymask[] = { 0x00040000, 0x00100000, 0x00200000 };
int hook = 0x00800000;
PortOut ledport(Port1, LED_MASK);

Serial pc(USBTX, USBRX); // tx, rx

PortIn     p(Port2, 0x00000007);   // p24-p26 or 21 to 23
int bellmask[] = { 3, 5, 6 };

int main() {
    while(1) {
        int pins = p.read();
        if (pins != 7) {
            ledport = hook;
            wait(1.0);
            for (int i = 0; i < 3; i++) {
                if (pins == bellmask[i]) {
                    pc.printf("pins = %d\n",pins);
                    ledport = mymask[i] + hook;
                    wait(0.5);
                    ledport = hook;
                    wait(10.0);
                    ledport = 0;
                }    
            }
        }        
    }
}
