// Copyright 2010 Richard Parker

#ifndef MBED_EAWIDGET_H
#define MBED_EAWIDGET_H

#include "mbed.h"

class EALCD;

/**
 * Class to handle generic widget values.
 * @author Richard Parker
 */
class EAWidget
{
public:
    EAWidget();
    ~EAWidget();
    
    inline unsigned short width() const { return _width; }
    inline unsigned short height() const { return _height; }

    inline virtual void setWidth(unsigned short w) { _width = w; }
    inline virtual void setHeight(unsigned short h) { _height = h; }

    inline short x() const { return _x; }
    inline short y() const { return _y; }

    inline virtual void setX(short x) { _x = x; }
    inline virtual void setY(short y) { _y = y; }

    virtual void paint(EALCD& lcd) = 0;

private:
    unsigned short _width;
    unsigned short _height;
    
    short _x;
    short _y;
    
};

#endif