// Copyright 2010 Richard Parker

#ifndef MBED_EACOMPASS_H
#define MBED_EACOMPASS_H

#include "mbed.h"

#include "EAWidget.h"

class EALCD;

/**
 * Class to handle displaying a button on screen with hitbox.
 * @author Richard Parker
 */
class EACompass: public EAWidget
{
public:  
    EACompass( short x = 0, 
              short y = 0, 
              unsigned short diameter = 0, 
              unsigned short angle = 0);
              
    ~EACompass();
    
    virtual void paint(EALCD& lcd);
    void update(EALCD& lcd, float angle);
    
    inline void setAngle(float angle) { _angle = angle; }
    inline float angle() { return _angle; }    
    
    inline void setDiameter(unsigned short diameter) { _diameter = diameter; EAWidget::setWidth(diameter); EAWidget::setHeight(diameter);}
    inline unsigned short diameter() { return _diameter; }    

    inline virtual void setWidth(unsigned short w) { setDiameter(w); }
    inline virtual void setHeight(unsigned short h) { setDiameter(h); }

private:
    float _angle;
    unsigned short _diameter;
           
    void _drawPointer(EALCD& lcd);
    void _drawAngle(EALCD& lcd);
    
};

#endif