// Copyright 2010 Richard Parker

#include "mbed.h"

#include "EACompass.h"

#include "../graphics/EAPen.h"
#include "../graphics/EAColor.h"
#include "../screen/EALCD.h"

EACompass::EACompass( short x, 
              short y, 
              unsigned short diameter, 
              unsigned short angle)
{
    setX(x);
    setY(y);
    setWidth(diameter);
    setHeight(diameter);
    
    setAngle(angle);    
}

EACompass::~EACompass()
{
}

void EACompass::paint(EALCD& lcd)
{
    // Draw the outer ring.
    lcd.drawFilledEllipse(x(), y(), diameter(), diameter());
    
    // Now draw the pointer.
    _drawPointer(lcd);
    
    // Next draw the angle value.
    _drawAngle(lcd);
}

void EACompass::update(EALCD& lcd, float angle)
{
    // Clear the old pointer.
    EAColor oldColour = lcd.pen().color();
    EAColor bg = lcd.brush().color();
    EAPen p;
    
    p.setColor(bg);
    lcd.setPen(p);    

    _drawPointer(lcd);
    _drawAngle(lcd);
    
    p.setColor(oldColour);
    lcd.setPen(p);
  
    // Now set the new angle and draw the pointer.
    setAngle(angle);
    
    _drawPointer(lcd);
    _drawAngle(lcd);
}

void EACompass::_drawPointer(EALCD& lcd)
{
    unsigned short r = diameter()/2;
    unsigned short h = r - 10;
    short oy = h * sin(angle());
    short ox = h * cos(angle());
    
    short x0 = r + x() - ox;
    short y0 = r + y() + oy;
    short x1 = r + x() + ox;
    short y1 = r + y() - oy;
    
    // Draw main line.        
    lcd.drawLine(x0, y0, x1, y1);
    
    // Draw ball at north end.
    lcd.drawFilledEllipse(x1-5, y1-5, 10, 10);
}

void EACompass::_drawAngle(EALCD& lcd)
{
    short tx = x() + (diameter()/2);
    short ty = y() + diameter();

    EAFont font;
    
    font.load("/local/small.fnt");   
    lcd.setFont(font);  

    /*
    REVISIT - formatting string to draw heading.
    char angleBuffer[5];
    float angleDeg = (angle() * 180)/PI;
    sprintf(angleBuffer, "%03.0f", angleDeg);
    
    lcd.drawText(tx, ty, angleBuffer);
    */
    
}
