// Copyright 2010 Richard Parker

#ifndef MBED_EABUTTON_H
#define MBED_EABUTTON_H

#include "mbed.h"
#include <string>

#include "EAWidget.h"

class EALCD;
class EAHitBox;
class EATouchManager;
class EAHitHandler;

/**
 * Class to handle displaying a button on screen with hitbox.
 * @author Richard Parker
 */
class EAButton: public EAWidget
{
public:  
    EAButton( EATouchManager& manager, 
              short x = 0, 
              short y = 0, 
              unsigned short width = 0, 
              unsigned short height = 0, 
              char* text = NULL, 
              EAHitHandler* handler = NULL);
              
    ~EAButton();
    
    virtual void paint(EALCD& lcd);
    
    bool setText(const std::string& text);
    inline const string& text() const { return _text; }

    EAHitHandler* handler() const;
    void setHandler(EAHitHandler* handler);

    bool enabled() const;
    void setEnabled(bool yes);
    
    inline virtual void setX(short x) { EAWidget::setX(x); _updateHitBox(); }
    inline virtual void setY(short y) { EAWidget::setY(y); _updateHitBox(); }
   
    inline virtual void setWidth(unsigned short w) { EAWidget::setWidth(w); _updateHitBox(); }
    inline virtual void setHeight(unsigned short h) { EAWidget::setHeight(h); _updateHitBox(); }
    
    inline EAHitBox* hitBox() const { return _box; }
    
private:
    EATouchManager& _manager;
    EAHitBox* _box;
    
   std::string _text;
    
    void _updateHitBox();
};

#endif