// Copyright 2010 Richard Parker

#include "mbed.h"

#include "EAButton.h"

#include "../manager/EATouchManager.h"
#include "../manager/EAHitBox.h"
#include "../manager/EAHitHandler.h"
#include "../graphics/EAPen.h"
#include "../graphics/EAColor.h"
#include "../screen/EALCD.h"

EAButton::EAButton( EATouchManager& manager, 
                    short x, 
                    short y, 
                    unsigned short width, 
                    unsigned short height, 
                    char* text, 
                    EAHitHandler* handler)
:   _manager(manager),
    _box(NULL),
    _text(NULL)
{
    _updateHitBox();

    setX(x);
    setY(y);
    setWidth(width);
    setHeight(height);
    setText(text);
    setHandler(handler);    
}

EAButton::~EAButton()
{
    // If created box then delete from manager.
    if (_box != NULL)
    {
        _manager.deleteHitBox(_box);
        _box = NULL;
    }   
}

void EAButton::paint(EALCD& lcd)
{
    lcd.drawFilledRect(x(), y(), width(), height());
    if (_text.empty() == false)
    {
        lcd.drawText(x()+10, y()+10, _text);
    }
}

bool EAButton::setText(const std::string& text)
{   
    _text = text;
    
    return true;
}

void EAButton::_updateHitBox()
{
    if (_box == NULL)
    {
        // Create the hitbox.
        _box = _manager.createHitBox();
    }
    
    // Update the position of the hit box to match the size and position of the 
    // drawn button.
    if (_box != NULL)
    {
        _box->setX(x());
        _box->setY(y());
        _box->setWidth(width());
        _box->setHeight(height());
    }
}

EAHitHandler* EAButton::handler() const
{
    if (_box != NULL)
    {
        return _box->handler();
    } else {
        return NULL;
    }
}

void EAButton::setHandler(EAHitHandler* handler)
{
    if (_box != NULL)
    {
        _box->setHandler(handler);
    }
}

bool EAButton::enabled() const
{
    if (_box != NULL)
    {
        return _box->enabled();
    } else {
        return false;
    }
}

void EAButton::setEnabled(bool yes)
{
    if (_box != NULL)
    {
        _box->setEnabled(yes);
    }
}
