// Copyright 2010 Richard Parker

#ifndef MBED_EATOUCHMANAGER_H
#define MBED_EATOUCHMANAGER_H

#include "mbed.h"

class EATouch;
class EALCD;
class EAHitBox;

/**
 * Class to handle the hits on the touch screen
 * @author Richard Parker
 */
class EATouchManager
{
public:
    EATouchManager(EALCD& lcd, EATouch& touch);
    
    ~EATouchManager();
    
    void tick();
    
    void deleteHitBox(EAHitBox* box);
    EAHitBox* createHitBox();
    void clearHitBoxes();

    inline EAHitBox* head() { return _head; }
    
    inline void setTimeout(unsigned int timeout) { _timeout = timeout; }
    inline unsigned int timeout() { return _timeout; }
    
private:
    EATouch& _touch;
    EALCD& _lcd;
    
    EAHitBox* _head;
    
    unsigned int _count;
    unsigned int _timeout;
    
    void _doHits(short x, short y);
    
    void _watchReset();
    void _watchCheck();
    
};

#endif