// Copyright 2010 Richard Parker

#ifndef MBED_EAHITBOX_H
#define MBED_EAHITBOX_H

#include "mbed.h"

#include "../widgets/EAWidget.h"

class EAHitBox;
class EAHitHandler;

/**
 * Class to handle detection of a hit in an area of the screen.
 * @author Richard Parker
 */
class EAHitBox
{
public:
    typedef void (*ActionFunction)(EAHitBox*, short, short) ;

    EAHitBox();
    
    ~EAHitBox();

    inline unsigned short width() const { return _width; }
    inline unsigned short height() const { return _height; }

    inline void setWidth(unsigned int w) { _width = w; }
    inline void setHeight(unsigned int h) { _height = h; }

    inline unsigned short x() const { return _x; }
    inline unsigned short y() const { return _y; }

    inline void setX(short x) { _x = x; }
    inline void setY(short y) { _y = y; }
    
    inline EAHitBox* next() const { return _next; }
    inline void setNext(EAHitBox* value) { _next = value; }
    
    bool checkContains(short x, short y);
    
    inline void setAction(EAHitBox::ActionFunction action) { _action = action; }
    
    inline EAHitHandler* handler() const { return _handler; }
    inline void setHandler(EAHitHandler* value) { _handler = value; }
    
    inline bool enabled() { return _enabled; }
    inline void setEnabled(bool yes) { _enabled = yes; }

private:    
    EAHitBox* _next;
    
    EAHitHandler* _handler;
    
    unsigned short _width;
    unsigned short _height;
    
    short _x;
    short _y;
    
    bool _enabled;
    
    ActionFunction _action;
    
};

#endif