#include "mbed.h"
#include "EAHitBox.h"
#include "EAHitHandler.h"

EAHitBox::EAHitBox()
:   _next(NULL),
    _handler(NULL),
    _width(0),
    _height(0),
    _x(0),
    _y(0),
    _enabled(true),
    _action(NULL)
{
}

EAHitBox::~EAHitBox()
{
}

bool EAHitBox::checkContains(short x, short y)
{
    bool result = false;
      
    if  (
            (x > this->x())
            &&
            (x < this->x() + width())
            &&
            (y > this->y())
            &&
            (y < this->y() + height())
        )
    {
        // This is a hit.
        result = true;
    }
       
    if ((result == true) && (enabled() == true))
    {
        // Hit inside and an action is defined.
        if (_handler != NULL)
        {
            // Call member function on object.
            _handler->actionHandler(this, x, y);
        }
        
        if (_action != NULL)
        {
            // Call global handler.
            _action(this, x, y);
        }
    }
    
    return result;
}
