// Copyright 2010 Richard Parker

#ifndef MBED_EAIMAGE_H
#define MBED_EAIMAGE_H

#include "mbed.h"
#include <string>

#include "EAWidget.h"

class EALCD;
class EAColor;

/**
 * Class to handle loading and displaying an image.
 * @author Richard Parker
 */
class EAImage: public EAWidget
{
public:
    struct EABMPHeader {
        unsigned int headerSize;
        unsigned int width;
        unsigned int height;
        unsigned short noColorPlanes;
        unsigned short bitsPerPixel;
        unsigned int compressionType;
        unsigned int bmpSize;
        unsigned int horizontalRes;
        unsigned int verticalRes;
        unsigned int noColors;
        unsigned int noImportantColors;
    };
    
    EAImage();
    ~EAImage();
    
    bool load(const std::string& path);
    void unload();
    
    inline const std::string& path() const { return _path; }
    
    inline bool isValid() const { return (_path.empty() == false); }
    
    virtual void paint(EALCD& lcd);
    virtual void paint(EALCD& lcd, unsigned int x, unsigned int y, unsigned int w, unsigned int h);
    
    inline const EABMPHeader& info() { return _header; }
    
    inline bool isMask() { return _mask; }
    inline void setMask(bool value) { _mask = value; }
    
private:
    std::string _path;
    EAColor* _palette;
    unsigned int _dataOffset;
    EABMPHeader _header;
    bool _mask;
    
    bool _loadHeader(const string& path);
    bool _loadPalette(FILE* fp);
    
    int _wordsInRow();
    int _wordForX(unsigned int x);
    int _xWordOffset(unsigned int x);
    unsigned short _getColourAtOffset(unsigned int word, int offset);
    
    int _fseek(FILE* stream, long int offset, int origin);
    size_t _fread(void* ptr, size_t size, size_t count, FILE* stream);
    int _feof(FILE* stream);
};

#endif