// Copyright 2010 Richard Parker

#ifndef MBED_EAPEN_H
#define MBED_EAPEN_H

#include "mbed.h"

#include "EAColor.h"

/**
 * Class to handle the pen for the EA LCD.
 * @author Richard Parker
 */
class EAPen
{
public:
    EAPen();    
    EAPen(const EAColor& color);
    
    ~EAPen();
    
    inline const EAColor& color() const { return _color; }
    inline void setColor(const EAColor& c) { _color = c; }
    
private:
    EAColor _color;
    
};

#endif