// Copyright 2010 Richard Parker

#ifndef MBED_EACOLOR_H
#define MBED_EACOLOR_H

#include "mbed.h"

/**
 * Class to handle the 16 bit colour values as rgb.
 * @author Richard Parker
 */
class EAColor
{
public:
    EAColor();    
    EAColor(const EAColor& color);
    EAColor(unsigned char r, unsigned char g, unsigned char b);
    
    ~EAColor();
    
    /**
     * Retrieve the raw 16 bit value for the colour.
     */
    inline unsigned short rawValue() const { return _value; }
    
    /**
     * Set the colour by specifying the raw value
     * @param    c    The raw colour number
     */
    inline void setRawValue(unsigned short c) { _value = c; }

    /**
     * Set the colour by specifying the individual rgb components.
     * @param    r    The red component range = 0x0 - 0xff.
     * @param    g    The green component range = 0x0 - 0xff.
     * @param    b    The blue component range = 0x0 - 0xff.
     */
    void setRgb(unsigned char r, unsigned char g, unsigned char b);
    
    /**
     * Retrieve the red component of the current colour value.
     * @returns The 5 bits of red component.
     */    
    unsigned char red() const;    

    /**
     * Retrieve the green component of the current colour value.
     * @returns The 6 bits of green component.
     */    
    unsigned char green() const;

    /**
     * Retrieve the blue component of the current colour value.
     * @returns The 5 bits of blue component.
     */    
    unsigned char blue() const;
    
private:
    /**
     * 16 bit internal colour storage.
     */
    unsigned short _value;
    
};

#endif