// Copyright 2010 Richard Parker

#include "mbed.h"
#include "EAColor.h"

EAColor::EAColor()
:    _value(0x0000)
{
}

EAColor::EAColor(const EAColor& color)
:    _value(color.rawValue())
{
}

EAColor::EAColor(unsigned char r, unsigned char g, unsigned char b)
{
    setRgb(r, g, b);    
}

EAColor::~EAColor()
{
}

void EAColor::setRgb(unsigned char r, unsigned char g, unsigned char b)
{
    // Convert to RGB-565 format to fit in 16 bit number.
    unsigned short temp = 0x0000;

    _value = 0x0000;
    
    // Scale r to fit.
    r = ((float)r/0xff)*0x1f;
    // This places lower 5 bits of r at the top of _value
    temp = r;      
    temp = temp << 11;
    temp = temp & 0xf800;
    
    _value = _value | temp;
    
    // Scale g to fit.
    g = ((float)g/0xff)*0x3f;
    // This places lower 6 bits of g at next position.
    temp = g;
    temp = temp << 5;
    temp = temp & 0x07e0;
    
    _value = _value | temp;
           
    // Scale b to fit.
    b = ((float)b/0xff)*0x1f;
    // This places lower 5 bits of b at next position.
    temp = b;
    temp = temp << 0;
    temp = temp & 0x001f;
    
    _value = _value | temp;
}

unsigned char EAColor::red() const
{
    unsigned short temp = _value;
    return ((temp >> 11) & 0x001f);
}

unsigned char EAColor::green() const
{
    unsigned short temp = _value;
    return ((temp >> 6) & 0x003f);
}

unsigned char EAColor::blue() const
{
    unsigned short temp = _value;
    return ((temp >> 0) & 0x001f);
}
