// Copyright 2010 Richard Parker

#ifndef MBED_EABRUSH_H
#define MBED_EABRUSH_H

#include "mbed.h"

#include "EAColor.h"

/**
 * Class to handle the brush for the EA LCD.
 * @author Richard Parker
 */
class EABrush
{
public:
    EABrush();    
    EABrush(const EAColor& color);
    
    ~EABrush();
    
    inline const EAColor& color() const { return _color; }
    inline void setColor(const EAColor& c) { _color = c; }
    
private:
    EAColor _color;
    
};

#endif