// Copyright 2010 Richard Parker

#ifndef MBED_EAFONTCACHEENTRY_H
#define MBED_EAFONTCACHEENTRY_H

#include "mbed.h"

#include <string>
#include <vector>

#include "EAFont.h"
#include "EAImage.h"

/**
 * Class to handle the font cache entries for the EA LCD.
 * @author Richard Parker
 */
class EAFontCacheEntry
{
public:    
    EAFontCacheEntry();
    ~EAFontCacheEntry();
  
    bool load(const std::string& path);
    void unload();
    
    inline const std::string& path() { return _path; }
    inline int noChars() { return _chars.size(); }
    inline const std::vector<EAFont::EACharacter>& chars() { return _chars; }
    inline const EAImage& data() { return _img; }
    inline int references() { return _refs; }
    
    void incReferences();
    void decReferences();

private:
    std::vector<EAFont::EACharacter> _chars;
    std::string _path;
    int _refs;
    EAImage _img;

};

#endif