// Copyright 2010 Richard Parker

#ifndef MBED_EAFONTCACHE_H
#define MBED_EAFONTCACHE_H

#include "mbed.h"
#include <string>
#include <vector>

#include "EAFontCacheEntry.h"

/**
 * Class to handle the font cache for the EA LCD.
 * @author Richard Parker
 */
class EAFontCache
{
public:    
    static EAFontCache& instance();
    
    EAFontCacheEntry* getCharacters(const std::string& path);
    void returnCharacters(EAFontCacheEntry* entry);
    
private:
    std::vector<EAFontCacheEntry*> _entries;

    EAFontCache();   
    ~EAFontCache();

    EAFontCache(const EAFontCache&);             // intentionally undefined
    EAFontCache& operator=(const EAFontCache&);  // intentionally undefined

    void _clearCacheEntries();
    void _deleteCacheEntry(EAFontCacheEntry* entry);
    EAFontCacheEntry* _createCacheEntry();
    
};

#endif