// Copyright 2010 Richard Parker

#ifndef MBED_EAFONT_H
#define MBED_EAFONT_H

#include "mbed.h"

#include <string>

class EALCD;
class EAFontCacheEntry;
class EAImage;

/**
 * Class to handle the font for the EA LCD.
 * @author Richard Parker
 */
class EAFont
{
public:
    friend EALCD;
    
    struct EACharacter
    {
        unsigned char id;
        unsigned char x;
        unsigned char y;
        unsigned char width;
        unsigned char height;
        unsigned char xOffset;
        unsigned char yOffset;
        unsigned char xAdvance;
    };

    EAFont();   
    ~EAFont();
       
    EAFont(const EAFont& font);
    EAFont& operator=(const EAFont& font);
       
    bool isValid() const;
    bool load(const std::string& path);
    
//private:
    EAFontCacheEntry* _entry;

    bool _getCharacter(char c, EACharacter& detail);
    bool _data(EAImage& image);
    
};

#endif