// Copyright 2010 Richard Parker

#include "mbed.h"
#include "EAFont.h"

#include "EAFontCache.h"
#include "EAFontCacheEntry.h"
#include "../screen/EALCD.h"
#include "../images/EAImage.h"

EAFont::EAFont()
:   _entry(NULL)
{
}

EAFont::~EAFont()
{
    // Return reference to characters.
    if (_entry != NULL)
    {
        EAFontCache::instance().returnCharacters(_entry);
        _entry = NULL;
    }
}

EAFont::EAFont(const EAFont& font)
{   
    // Do copy like this to ensure that the references in the cache are kept up-to-date.
    if (font._entry != NULL)
    {
        _entry = EAFontCache::instance().getCharacters(font._entry->path());
    } else {
        _entry = NULL;
    }
}

EAFont& EAFont::operator=(const EAFont& font)
{
    if (&font == this)
    {
        return *this;
    }

    // Return the current entry.
    if (_entry != NULL)
    {
        EAFontCache::instance().returnCharacters(_entry);
        _entry = NULL;
    }

    // Do copy like this to ensure that the references in the cache are kept up-to-date.
    if (font._entry != NULL)
    {
        _entry = EAFontCache::instance().getCharacters(font._entry->path());
    } else {
        _entry = NULL;
    }
    
    return *this;
}


bool EAFont::load(const std::string& path)
{
    if (path.empty() == true)
    {
        // Invalid path passed in.
        return false;
    }
    
    // Return entry if needed.
    if (_entry != NULL)
    {
        EAFontCache::instance().returnCharacters(_entry);
        _entry = NULL;
    }
       
    // Load font descriptor into look up table.  
    _entry = EAFontCache::instance().getCharacters(path);

    if (_entry == NULL)
    {
        return false;
    }
      
    return true;    
}

bool EAFont::isValid() const 
{ 
    return (_entry != NULL);
}

bool EAFont::_getCharacter(char c, EACharacter& detail)
{
    if (_entry == NULL)
    {
        return false;
    }

    for (int i = 0; i < _entry->noChars(); i++)
    {
        if (_entry->chars()[i].id == c)
        {
            detail = _entry->chars()[i];
            return true;
        }
    }
    
    return false;
}

bool EAFont::_data(EAImage& image) 
{ 
    if (_entry == NULL)
    {
        return false;
    }
    
    image = _entry->data();
    
    return true;
}

