// Copyright 2010 Richard Parker

#ifndef MBED_EASETTINGS_H
#define MBED_EASETTINGS_H

#include "mbed.h"

#include "../manager/EAHitHandler.h"

class EALCD;
class EATouchManager;
class EAButton;
class EATouch;
class EACompass;
class HMC6352;

/**
 * Class to handle setting up the peripherals on the EA star gazer board.
 * @author Richard Parker
 */
class EASettings: public EAHitHandler
{
public:
    enum State {
        STATE_IDLE,
        STATE_ENDED,
        STATE_PORTAL,
        STATE_DATE_DAY,
        STATE_DATE_MONTH,
        STATE_DATE_YEAR,
        STATE_DATE_HOUR,
        STATE_DATE_MINUTE,
        STATE_DATE_SECOND,
        STATE_COMPASS
    };

    EASettings(EALCD& lcd, EATouch& touch, EATouchManager& manager, HMC6352& compass);
    ~EASettings();
    
    void start();
    
    inline unsigned short size() { return 40; }

    virtual void actionHandler(EAHitBox* box, short x, short y);
    
    inline EASettings::State state() { return _state; }
    
    void redrawCompass();
    
    void tick();
    
private:
    EALCD& _lcd;
    EATouch& _touch;
    EATouchManager& _manager;
    HMC6352& _compass;
        
    struct tm* _time;
    EACompass* _compassCircle;
    
    EAButton* _launchBox;
    EAButton* _returnBox;  
    EAButton* _touchBox;
    EAButton* _dateBox;
    EAButton* _compassBox;
    EAButton* _nextBox;
    EAButton* _prevBox;
    EAButton* _incBox;   
    EAButton* _decBox;
       
    EASettings::State _state;
    
    void _disableHitBoxs();
    
    void _drawLaunchButton();
    void _drawPortal();

    void _updateCompass();
    void _drawCompass();
    
    void _drawDate();
        
    EASettings::State _incDate();
    EASettings::State _decDate();
    EASettings::State _nextDate();
    EASettings::State _prevDate();
    void _enableDateButtons();
    
};

#endif
