#include "mbed.h"
#include "BtnEventM0.h"

//        LSB                                           MSB
BusOut lb(P1_7,P1_6,P1_4,P1_3,P1_1,P1_0,LED4,LED3,LED2,LED1);

// Statusled zeigt uns in welchem Zustand due Statemachine gerade ist
BusOut stLED(P1_13,P1_12);

// BtnEventM0 erledigt für uns die Abfrage der positiven Flanke
BtnEventM0 sw4(P1_16), sw3(P0_23);
// sw4==forew sw3==backward


class FahrradLeuchte {
    public:
        void init()
        {
            state=1; t1.start();    
        }
        void State1Func();
        void State2Func();
        void State3Func();
    public:
        void State1Action(); // Bit0 (LED) mit 10 Hz blinken
        void State2Action(); // Bit2 (LED) mit 5 Hz blinken
        void State3Action(); // Bit4 (LED) mit 2 Hz blinken
    public:
    // State sagt uns in welchem Zustand sich die Fahrradleuchte gerade befindet
    int state;
    Timer t1;
};

// eine Fahrradleuchte anlegen
FahrradLeuchte fl;

int main(void)
{
    sw3.Init(); sw4.Init();
    lb = 0;
    while(1)
    {
        if (fl.state==1)
            fl.State1Func();
        if (fl.state==2)
            fl.State2Func();
        if (fl.state==3)
            fl.State3Func();
    }
}

void FahrradLeuchte::State1Func()
{
    
    // Einmalige Aktion beim Eintritt in die Zustandsfunktion
    stLED = 1; // Anzeigen, dass ir im Zustand 1 sind
    t1.reset();
    while(1)
    {
        State1Action();
        // Btn's abfragen und möglicherweise Zustand ändern
        if(sw4.CheckFlag())
        {state= 2; return;}
        if(sw3.CheckFlag())
        {state= 3; return;}
    }
    
}

void FahrradLeuchte:: State1Action()
{
    if (t1.read_ms() > 100 )
    {
        t1.reset();
        if (lb == 0)
           lb = 1; // Mit Bit0 blinken
        else
            lb = 0;
    }
}

void FahrradLeuchte::State2Func()
{
    
}

void FahrradLeuchte::State3Func()
{
    
}