#include "mbed.h"
#include "SDFileSystem.h"

SDFileSystem sd(p5, p6, p7, p8, "sd"); // MOSI, MISO, SCLK, SSEL
DigitalOut myled(LED1);

int main() {
    printf("Starting download...\r\n");
    
    sd.disk_initialize();
    
    uint8_t buffer[0x200];
    sd.disk_read(buffer, 0);

    int block_count = ((uint32_t*)buffer)[0];
    printf("%d blocks to download...\r\n\r\n", block_count);
    
    char command;
    printf("\r\nPress 'd' to download, 'c' to clear:\r\n");
    scanf("%c", &command);
    
    if (command == 'd') {
        for (int i = 1; i < block_count; i++) {   
            sd.disk_read(buffer, i);
            printf("%s\r", (char*)buffer);        
        }   
    } else if (command == 'c') {
        printf("\r\nClearing first sector...\r\n");
        ((uint32_t*)buffer)[0] = 0;
        sd.disk_write(buffer, 0);
    }
}