#include "mbed.h"
#include "HIDScope.h"
#include "encoder.h"


//pinverdeling en naamgeving variabelen
Encoder motor1(D13,D12);        // telt pulsen bij verdraaiing en zet dit om in de rotatiehoek
PwmOut led(D9);
DigitalOut motor_direction(D4); // motor direction
PwmOut motor_speed(D5);         // motor speed
DigitalIn button_1(PTC6);       // counterclockwise
DigitalIn button_2(PTA4);       // clockwise
HIDScope scope(1);              // Hidscope op channel 1??!!

const int pressed = 0;     //signaal(beweging) bij indrukken

void move_motor_ccw ()  //beweging ccw motor 1, signaal van linker biceps
{
    motor_direction = 0;
    motor_speed = 1;
}

void move_motor_cw ()   // beweging cw motor 1, signaal van rechter biceps
{
    motor_direction = 1;
    motor_speed = 0.1;
}

void read_encoder ()    // aflezen van encoder via hidscope??
{
    scope.set(0,motor1.getPosition());
    led.write(motor1.getPosition()/100.0);
    scope.send();
    wait(0.2f);
}

void move() // beweging van motor 1 cw of ccw d.m.v. button 1 of 2
{
    if (button_1 == pressed) {
        move_motor_cw ();
    } else if (button_2 == pressed) {
        move_motor_ccw ();
    } else {
        motor_speed = 0;
    }
}

//uitvoeren van script
int main()
{
    while (true) {

        read_encoder();
        move();
    }

}

