#include "mbed.h"
#include "HIDScope.h"

AnalogIn EMG_bicepsright(A0);
AnalogIn EMG_bicepsleft(A1);
HIDScope scope(4);
Ticker EMG;
Ticker Scope;

//EMG calibration
Timer biceps_calibration;
Ticker EMGCALIBRATION;
volatile bool regulation_EMG_flag;
void setregulation_EMG_flag()
{
    regulation_EMG_flag = true;
}

// Filter1 = High pass filter tot 20 Hz
double fh1_v1=0, fh1_v2=0, fh2_v1=0, fh2_v2=0;
const double fh1_a1=-0.84909054461, fh1_a2=0.00000000000, fh1_b0= 1, fh1_b1=-1, fh1_b2=0;
const double fh2_a1=-1.82553264091, fh2_a2=0.85001416809, fh2_b0= 1, fh2_b1=-2, fh2_b2=1;
// Filter2 = Low pass filter na 60 Hz
double fl1_v1=0, fl1_v2=0, fl2_v1=0, fl2_v2=0;
const double fl1_a1=-0.66979455390, fl1_a2=0.00000000000, fl1_b0= 1, fl1_b1=1, fl1_b2=0;
const double fl2_a1=-1.55376616139, fl2_a2=0.68023470431, fl2_b0= 1, fl2_b1=2, fl2_b2=1;
// Filter3 = Notch filter at 50 Hz
double fno1_v1=0, fno1_v2=0, fno2_v1=0, fno2_v2=0, fno3_v1=0, fno3_v2=0;
const double fno1_a1 = -1.87934916386, fno1_a2= 0.97731851355, fno1_b0= 1, fno1_b1= -1.90090686046, fno1_b2= 1;
const double fno2_a1 = -1.88341028603, fno2_a2= 0.98825147717, fno2_b0= 1, fno2_b1= -1.90090686046, fno2_b2= 1;
const double fno3_a1 = -1.89635403726, fno3_a2= 0.98894004849, fno3_b0= 1, fno3_b1= -1.90090686046, fno3_b2= 1;
// Filter4 = Lowpass filter at 5 Hz
double flp1_v1=0, flp1_v2=0, flp2_v1=0, flp2_v2=0;
const double flp1_a1=-0.97922725527, flp1_a2=0.00000000000, flp1_b0= 1, flp1_b1=1, flp1_b2=0;
const double flp2_a1=-1.97879353121, flp2_a2=0.97922951943, flp2_b0= 1, flp2_b1=2, flp2_b2=1;
double y1, y2, y3, y4, y5, y6, y7, y8, y9, 
y10, y11, y12, y13, y14, y15, y16, y17, y18;
double u1, u2, u3, u4, u5, u6, u7, u8, u9, 
u10, u11, u12, u13, u14, u15, u16, u17, u18;
double final_filter1, final_filter2;

// Standaard formule voor het biquad filter
double biquad(double u, double &v1, double &v2, const double a1, const double a2, const double b0, const double b1, const double b2)

{
    double v = u - a1*v1 - a2*v2;
   double y = b0*v + b1*v1 + b2*v2;
  v2=v1;
  v1=v;
   return y;
}


void Signaal_EMG()
{
     // left
    u1 = EMG_bicepsright.read();
    //Highpass
    y1 = biquad (u1, fh1_v1, fh1_v2, fh1_a1, fh1_a2, fh1_b0*0.924547, fh1_b1*0.924547, fh1_b2*0.924547);
    y2 = biquad (y1, fh2_v1, fh2_v2, fh2_a1, fh2_a2, fh2_b0*0.918885, fh2_b1*0.918885, fh2_b2*0.918885);
    //Lowpass
    y3 = biquad (y2, fl1_v1, fl1_v2, fl1_a1, fl1_a2, fl1_b0*0.165103, fl1_b1*0.165103, fl1_b2*0.165103);
    y4 = biquad (y3, fl2_v1, fl2_v2, fl2_a1, fl2_a2, fl2_b0*0.031617, fl2_b1*0.031617, fl2_b2*0.031617);
    // Notch
    y5 = biquad (y4, fno1_v1, fno1_v2, fno1_a1, fno1_a2, fno1_b0*1.004206, fno1_b1*1.004206, fno1_b2*1.004206);
    y6 = biquad (y5, fno2_v1, fno2_v2, fno2_a1, fno2_a2, fno2_b0, fno2_b1, fno2_b2);
    y7 = biquad (y6, fno3_v1, fno3_v2, fno3_a1, fno3_a2, fno3_b0*0.973227, fno3_b1*0.973227, fno3_b2*0.973227);
    // Rectify sample
    y8 = fabs(y7);
    // Make it smooth
    y9 = biquad (y8, flp1_v1, flp1_v2, flp1_a1, flp1_a2, flp1_b0* 0.010386, flp1_b1* 0.010386, flp1_b2* 0.010386);
    final_filter1 = biquad(y9, flp2_v1, flp2_v2, flp2_a1, flp2_a2, flp2_b0*0.000109, flp2_b1*0.000109, flp2_b2*0.000109);

    //Biceps right
    u10 = EMG_bicepsleft.read();
    //Highpass
    y10 = biquad (u10, fh1_v1, fh1_v2, fh1_a1, fh1_a2, fh1_b0*0.924547, fh1_b1*0.924547, fh1_b2*0.924547);
    y11 = biquad (y10, fh2_v1, fh2_v2, fh2_a1, fh2_a2, fh2_b0*0.918885, fh2_b1*0.918885, fh2_b2*0.918885);
    //Lowpass
    y12 = biquad (y11, fl1_v1, fl1_v2, fl1_a1, fl1_a2, fl1_b0*0.165103, fl1_b1*0.165103, fl1_b2*0.165103);
    y13 = biquad (y12, fl2_v1, fl2_v2, fl2_a1, fl2_a2, fl2_b0*0.031617, fl2_b1*0.031617, fl2_b2*0.031617);
    // Notch
    y14 = biquad (y13, fno1_v1, fno1_v2, fno1_a1, fno1_a2, fno1_b0*1.004206, fno1_b1*1.004206, fno1_b2*1.004206);
    y15 = biquad (y14, fno2_v1, fno2_v2, fno2_a1, fno2_a2, fno2_b0, fno2_b1, fno2_b2);
    y16 = biquad (y15, fno3_v1, fno3_v2, fno3_a1, fno3_a2, fno3_b0*0.973227, fno3_b1*0.973227, fno3_b2*0.973227);
    // Rectify sample
    y17 = fabs(y16);
    // Make it smooth
    y18 = biquad (y17, flp1_v1, flp1_v2, flp1_a1, flp1_a2, flp1_b0* 0.010386, flp1_b1* 0.010386, flp1_b2* 0.010386);
    final_filter2 = biquad(y18, flp2_v1, flp2_v2, flp2_a1, flp2_a2, flp2_b0*0.000109, flp2_b1*0.000109, flp2_b2*0.000109);
}

void HIDScope(){
    scope.set(0, u1);
    scope.set(1, u10);
    scope.set(2, final_filter1);
    scope.set(3, final_filter2);
    scope.send();
   } 

int main ()
{
    EMG.attach_us(Signaal_EMG,1e3);
    Scope.attach_us(HIDScope,1e3);

    pc.printf("EMG_Kalibratie_biceps/n/r");
    lcd.locate(0,0);
    lcd.printf("start in 5 sec")
    lcd.locate(0,1);
    wait(4);
    lcd.printf("contract both biceps");
    lcd.locate(0,2);
    wait(1);
    lcd.printf("start");
    lcd.cls();
    
    biceps_calibration.start();
    EMGCALIBRATION.attach_us(setregelaar_EMG_flag, 5e4);
    
    while(biceps_calibration.read() =< 5) {
        
        while(regulation_EMG_flag != true);
        regulation_EMG_flag = false;
        
        
        
}

