#include "mbed.h"

//------------------------------------
// Hyperterminal configuration
// 115200 bauds, 8-bit data, no parity
//------------------------------------

Serial pc(SERIAL_TX, SERIAL_RX); 
DigitalOut myled(LED1);
 
extern uint32_t __Vectors[];              
#define VECTORTABLE_SIZE        (512)     
#define VECTORTABLE_ALIGNMENT   (0x200ul)                                           
uint32_t vectorTable_RAM[VECTORTABLE_SIZE] __attribute__(( aligned (VECTORTABLE_ALIGNMENT) )); 
int j;
   
int main() {
  int i = 1;
  pc.baud(115200);
  pc.printf("Hello World !\r\n");
    
  //Duplicate and relocate the vector table 
  for (i = 0; i < VECTORTABLE_SIZE; i++) {
    vectorTable_RAM[i] = __Vectors[i];            /* copy vector table to RAM */
  }
  __disable_irq();
  SCB->VTOR = (uint32_t)(&vectorTable_RAM);
  __DSB();
  __enable_irq();
  
  //Print 100 lines - this is where things just go wrong and the program freezes
  for (j = 0; j <= 100; j++) 
  {
    pc.printf("test %d\r\n", j);    
  }

  while(1) { 
      wait(1);
      pc.printf("This program runs since %d seconds.\r\n", i++);
      myled = !myled;
  }
}
 