#include "mbed.h"

//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------

Serial pc(SERIAL_TX, SERIAL_RX);

DigitalOut myled(PC_13);

int main()
{
    __disable_irq(); //Should still be disabled from when you jumped out of the bootloader, but disable again for safety.
    uint32_t *old_vectors = (uint32_t *)(0x08010000U); //Or wherever you placed your main application
    uint32_t *vectors = (uint32_t*)NVIC_RAM_VECTOR_ADDRESS;
    for (int i = 0; i < NVIC_NUM_VECTORS; i++) {
        vectors[i] = old_vectors[i];
    }
    SCB->VTOR = (uint32_t)NVIC_RAM_VECTOR_ADDRESS;
    __enable_irq(); //Re-enable IRQ. In theory your vector table should now be copied and interrupt *should* work.
        
    
    pc.baud(115200);
    int i = 1;
    pc.printf("Hello World !\n");
    while(1) {
        wait(1);
        pc.printf("This program runs since %d seconds.\n", i++);
        myled = !myled;
    }
}
