#include <mbed.h>
#include <mpr121.h>
#include <math.h>
#include "mbed.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include "FATFileSystem.h"
#include "wave_player.h"
#include <stdio.h>
#include "Speaker.h"
#include "rtos.h"

//Class to control an RGB LED using three PWM pins
class RGBLed
{
public:
    RGBLed(PinName redpin, PinName greenpin, PinName bluepin);
    void write(float red,float green, float blue);
private:
    PwmOut _redpin;
    PwmOut _greenpin;
    PwmOut _bluepin;
};

RGBLed::RGBLed (PinName redpin, PinName greenpin, PinName bluepin)
    : _redpin(redpin), _greenpin(greenpin), _bluepin(bluepin)
{
    //50Hz PWM clock default a bit too low, go to 2000Hz (less flicker)
    _redpin.period(0.0005);
}

void RGBLed::write(float red,float green, float blue)
{
    _redpin = red;
    _greenpin = green;
    _bluepin = blue;
}

//Setup RGB led using PWM pins and class
RGBLed myRGBled(p21,p22,p23); //RGB PWM pins

//Bluetooth
Serial blue(p28,p27);
Serial pc(USBTX, USBRX);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
// Create the interrupt receiver object on pin 26
InterruptIn interrupt(p26);
// Setup the i2c bus on pins 9 and 10
I2C i2c(p9, p10);
// Setup the Mpr121:
// constructor(i2c object, i2c address of the mpr121)
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);

SDFileSystem sd(p5, p6, p7, p8, "sd");
uLCD_4DGL uLCD(p13,p14,p11);

AnalogOut DACout(p18);
wave_player waver(&DACout);
FILE *wave_file;

Mutex stdio_mutex;

int key_code;
// Key hit/release interrupt routine
void fallInterrupt()
{
    key_code=0;
    int i=0;
    int value=mpr121.read(0x00);
    value +=mpr121.read(0x01)<<8;
    // LED demo mod
    i=0;
    // puts key number out to LEDs for demo
    for (i=0; i<12; i++) {
        if (((value>>i)&0x01)==1) key_code=i+1;
    }
    led4=key_code & 0x01;
    led3=(key_code>>1) & 0x01;
    led2=(key_code>>2) & 0x01;
    led1=(key_code>>3) & 0x01;
}


int songcode = -1;
int isplay = 0;
int islearn = 0;
float volume = 0.25;
float octave = 3;


void readblue()
{
    while(1) {

        char bnum = 0;
        if (blue.readable()) {
            if (blue.getc()=='!') {
                if (blue.getc() == 'I') {
                    bnum = blue.getc();
                    //button mode
                    if (bnum == 'B') {
                        bnum = blue.getc();
                        //play song
                        if (bnum == '0') {
                            islearn = 0;
                            isplay = 1;
                            songcode = blue.getc() - '0';
                        }
                        //learn song
                        if (bnum == '1') {
                            islearn = 1;
                            isplay = 0;
                            songcode = blue.getc() - '0';
                            pc.printf("songcode = %d",songcode);
                        }
                    }
                    //seekbar mode
                    if (bnum == 'S') {
                        islearn = 0;
                        isplay = 0;
                        bnum = blue.getc();
                        //octave change
                        if (bnum == '0') {
                            octave = blue.getc() - '0';
                            octave = octave - 3;
                            octave = pow(2, octave);
                        }
                        //volume change
                        if (bnum == '1') {
                            //get tens digit first
                            int actualVol = blue.getc() - '0';
                            actualVol *= 10;
                            //then get ones digit
                            actualVol += blue.getc() - '0';
                            volume = (float)actualVol/(float)100;
                        }
                    }
                }
            }
        }
        Thread::wait(200);
    }
}

int main()
{

    Speaker mySpeaker(p25);
    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);
    uLCD.printf("welcome :)\n");
    wait(1.0);
    uLCD.printf("Initializing...\n");
    wait(1.0);
    uLCD.cls();
    int i= 0;
    int j=0;
    Thread thread;;
    thread.start(readblue);

    while (1) {
        if(islearn == 1) {
            pc.printf("songcode in learn = %d",songcode);
            if (songcode == 0) { //twinkle
                int song0[14] = {1, 1,8,8,10,10,8,6,6,5,5,3,3,1};
                char note0[14] = {'C','C','G','G','A','A','G','F','F','E','E','D','D','C'};
                j = 14;
                uLCD.cls();
                //uLCD.printf("starting \nTwinkle Twinkle \nLittle Star");
                //wait(4.0);
                while(i <j) {
                    uLCD.text_width(3);
                    uLCD.text_height(3);
                    uLCD.locate(2,2);

                    uLCD.printf("%c",note0[i]);

                    if(song0[i]==key_code) {
                        myRGBled.write(0.0,1.0,0.0 );
                        uLCD.cls();
                        i++;
                    } else if (song0[i] != key_code && key_code != 0) {
                        myRGBled.write(1.0,0.0,0.0 );
                    } else if (key_code == 0) {
                        myRGBled.write(0.0,0.0,0.0 );
                        pc.printf("STAR");
                    }

                    switch(key_code) { //uses a case statement for each individual touch sensor


                        case 1:
                            mySpeaker.PlayNote(261.6256, 0.5, volume);
                            break;
                        case 2:
                            mySpeaker.PlayNote(277.1826, 0.5, volume);
                            //mySpeaker.PlayNote(261.6256*2, 0.5, volume);
                            break;
                        case 3:
                            mySpeaker.PlayNote(293.6648, 0.5, volume);
                            break;
                        case 4:
                            mySpeaker.PlayNote(311.1270, 0.5, volume);
                            break;
                        case 5:
                            mySpeaker.PlayNote(329.6276, 0.5, volume);
                            break;
                        case 6:
                            mySpeaker.PlayNote(349.2282, 0.5, volume);
                            break;
                        case 7:
                            mySpeaker.PlayNote(369.9944, 0.5, volume);
                            break;
                        case 8:
                            mySpeaker.PlayNote(391.9954, 0.5, volume);
                            break;
                        case 9:
                            mySpeaker.PlayNote(415.3047, 0.5, volume);
                            break;
                        case 10:
                            mySpeaker.PlayNote(440.0, 0.5, volume);
                            break;
                        case 11:
                            mySpeaker.PlayNote(466.1638, 0.5, volume);
                            break;
                        case 12:
                            mySpeaker.PlayNote(493.8833, 0.5, volume);
                            break;
                    }
                }
                i = 0;
                uLCD.printf("Congratulations! \nYou learned \nTwinkle Twinkle \nLittle Star");
            } else if (songcode == 1) { //mary had a little lamb
                int song1[25] = {5, 3, 1, 3, 5, 5, 5, 3, 3, 3, 5, 8, 8, 5, 3, 1, 3, 5, 5, 5, 5, 3, 5, 3, 1};
                char note1[25] = {'E', 'D', 'C', 'D', 'E','E','E', 'D','D','D','E', 'G','G','E', 'D', 'C', 'D', 'E','E','E','E','D','E','D','C'};
                j = 25;
                uLCD.cls();
                //uLCD.printf("starting \nTwinkle Twinkle \nLittle Star");
                //wait(4.0);
                while(i <j) {
                    uLCD.text_width(3);
                    uLCD.text_height(3);
                    uLCD.locate(2,2);

                    uLCD.printf("%c",note1[i]);

                    if(song1[i]==key_code) {
                        myRGBled.write(0.0,1.0,0.0 );
                        uLCD.cls();
                        i++;
                    } else if (song1[i] != key_code && key_code != 0) {
                        myRGBled.write(1.0,0.0,0.0 );
                    } else if (key_code == 0) {
                        myRGBled.write(0.0,0.0,0.0 );
                        pc.printf("MARY");
                    }

                    switch(key_code) { //uses a case statement for each individual touch sensor


                        case 1:
                            mySpeaker.PlayNote(261.6256, 0.5, volume);
                            break;
                        case 2:
                            mySpeaker.PlayNote(277.1826, 0.5, volume);
                            //mySpeaker.PlayNote(261.6256*2, 0.5, volume);
                            break;
                        case 3:
                            mySpeaker.PlayNote(293.6648, 0.5, volume);
                            break;
                        case 4:
                            mySpeaker.PlayNote(311.1270, 0.5, volume);
                            break;
                        case 5:
                            mySpeaker.PlayNote(329.6276, 0.5, volume);
                            break;
                        case 6:
                            mySpeaker.PlayNote(349.2282, 0.5, volume);
                            break;
                        case 7:
                            mySpeaker.PlayNote(369.9944, 0.5, volume);
                            break;
                        case 8:
                            mySpeaker.PlayNote(391.9954, 0.5, volume);
                            break;
                        case 9:
                            mySpeaker.PlayNote(415.3047, 0.5, volume);
                            break;
                        case 10:
                            mySpeaker.PlayNote(440.0, 0.5, volume);
                            break;
                        case 11:
                            mySpeaker.PlayNote(466.1638, 0.5, volume);
                            break;
                        case 12:
                            mySpeaker.PlayNote(493.8833, 0.5, volume);
                            break;
                    }
                }
                i = 0;
                uLCD.printf("Congratulations! \nYou learned \nMary Had a \nLittle Lamb");
            } else if (songcode == 2) { //hot cross buns
                int song2[17] = {5, 3, 1, 5, 3, 1, 1, 1, 1, 1, 3, 3, 3, 3, 5, 3, 1};
                char note2[17] = {'E','D','C','E','D','C', 'C','C','C','C','D','D','D','D','E','D','C'};
                j = 17;
                uLCD.cls();
                //uLCD.printf("starting \nTwinkle Twinkle \nLittle Star");
                //wait(4.0);
                while(i <j) {
                    uLCD.text_width(3);
                    uLCD.text_height(3);
                    uLCD.locate(2,2);

                    uLCD.printf("%c",note2[i]);

                    if(song2[i]==key_code) {
                        myRGBled.write(0.0,1.0,0.0 );
                        uLCD.cls();
                        i++;
                    } else if (song2[i] != key_code && key_code != 0) {
                        myRGBled.write(1.0,0.0,0.0 );
                    } else if (key_code == 0) {
                        myRGBled.write(0.0,0.0,0.0 );
                        pc.printf("BUNS");
                    }

                    switch(key_code) { //uses a case statement for each individual touch sensor


                        case 1:
                            mySpeaker.PlayNote(261.6256, 0.5, volume);
                            break;
                        case 2:
                            mySpeaker.PlayNote(277.1826, 0.5, volume);
                            //mySpeaker.PlayNote(261.6256*2, 0.5, volume);
                            break;
                        case 3:
                            mySpeaker.PlayNote(293.6648, 0.5, volume);
                            break;
                        case 4:
                            mySpeaker.PlayNote(311.1270, 0.5, volume);
                            break;
                        case 5:
                            mySpeaker.PlayNote(329.6276, 0.5, volume);
                            break;
                        case 6:
                            mySpeaker.PlayNote(349.2282, 0.5, volume);
                            break;
                        case 7:
                            mySpeaker.PlayNote(369.9944, 0.5, volume);
                            break;
                        case 8:
                            mySpeaker.PlayNote(391.9954, 0.5, volume);
                            break;
                        case 9:
                            mySpeaker.PlayNote(415.3047, 0.5, volume);
                            break;
                        case 10:
                            mySpeaker.PlayNote(440.0, 0.5, volume);
                            break;
                        case 11:
                            mySpeaker.PlayNote(466.1638, 0.5, volume);
                            break;
                        case 12:
                            mySpeaker.PlayNote(493.8833, 0.5, volume);
                            break;
                    }
                }
                i = 0;
                uLCD.printf("Congratulations! \nYou learned \nHot Cross \nBuns");
            }
            //wait(4.0);
            uLCD.cls();
            islearn=0;
            //Thread::wait(200);
        } else if(isplay == 1) {
            uLCD.cls();
//            uLCD.printf("Playing song");
//            wait(2.0);
            if (songcode == 0) {
                mySpeaker.PlayNote(261.6256, 0.5, volume); //C
                mySpeaker.PlayNote(261.6256, 0.5, volume); //C
                mySpeaker.PlayNote(391.9954, 0.5, volume); //G
                mySpeaker.PlayNote(391.9954, 0.5, volume); //G
                mySpeaker.PlayNote(440.0, 0.5, volume); //A
                mySpeaker.PlayNote(440.0, 0.5, volume); //A
                mySpeaker.PlayNote(391.9954, 1.0, volume); //G
                mySpeaker.PlayNote(349.2282, 0.5, volume); //F
                mySpeaker.PlayNote(349.2282, 0.5, volume); //F
                mySpeaker.PlayNote(329.6276, 0.5, volume); // E
                mySpeaker.PlayNote(329.6276, 0.5, volume); //E
                mySpeaker.PlayNote(293.6648, 0.5, volume); //D
                mySpeaker.PlayNote(293.6648, 0.5, volume); //D
                mySpeaker.PlayNote(261.6256, 0.5, volume); //C
            } else if (songcode == 1) {
                mySpeaker.PlayNote(329.6276, 0.5, volume); // E
                mySpeaker.PlayNote(293.6648, 0.5, volume); //D
                mySpeaker.PlayNote(261.6256, 0.5, volume); //C
                mySpeaker.PlayNote(293.6648, 0.5, volume); //D
                mySpeaker.PlayNote(329.6276, 0.5, volume); // E
                mySpeaker.PlayNote(329.6276, 0.5, volume); // E
                mySpeaker.PlayNote(329.6276, 1.0, volume); // E
                mySpeaker.PlayNote(293.6648, 0.5, volume); //D
                mySpeaker.PlayNote(293.6648, 0.5, volume); //D
                mySpeaker.PlayNote(293.6648, 1.0, volume); //D
                mySpeaker.PlayNote(329.6276, 0.5, volume); // E
                mySpeaker.PlayNote(391.9954, 0.5, volume); //G
                mySpeaker.PlayNote(391.9954, 1.0, volume); //G
                mySpeaker.PlayNote(329.6276, 0.5, volume); // E
                mySpeaker.PlayNote(293.6648, 0.5, volume); //D
                mySpeaker.PlayNote(261.6256, 0.5, volume); //C
                mySpeaker.PlayNote(293.6648, 0.5, volume); //D
                mySpeaker.PlayNote(329.6276, 0.5, volume); // E
                mySpeaker.PlayNote(329.6276, 0.5, volume); // E
                mySpeaker.PlayNote(329.6276, 1.0, volume); // E
                mySpeaker.PlayNote(329.6276, 0.5, volume); // E
                mySpeaker.PlayNote(293.6648, 0.5, volume); //D
                mySpeaker.PlayNote(329.6276, 0.5, volume); // E
                mySpeaker.PlayNote(293.6648, 0.5, volume); //D
                mySpeaker.PlayNote(261.6256, 1.0, volume); //C
            } else if (songcode == 2) {
                mySpeaker.PlayNote(329.6276, 0.5, volume); // E
                mySpeaker.PlayNote(293.6648, 0.5, volume); //D
                mySpeaker.PlayNote(261.6256, 1.0, volume); //C
                mySpeaker.PlayNote(329.6276, 0.5, volume); // E
                mySpeaker.PlayNote(293.6648, 0.5, volume); //D
                mySpeaker.PlayNote(261.6256, 1.0, volume); //C
                mySpeaker.PlayNote(261.6256, 0.5, volume); //C
                mySpeaker.PlayNote(261.6256, 0.5, volume); //C
                mySpeaker.PlayNote(261.6256, 0.5, volume); //C
                mySpeaker.PlayNote(261.6256, 0.5, volume); //C
                mySpeaker.PlayNote(293.6648, 0.5, volume); //D
                mySpeaker.PlayNote(293.6648, 0.5, volume); //D
                mySpeaker.PlayNote(293.6648, 0.5, volume); //D
                mySpeaker.PlayNote(329.6276, 0.5, volume); // E
                mySpeaker.PlayNote(293.6648, 0.5, volume); //D
                mySpeaker.PlayNote(261.6256, 1.0, volume); //C
            }
            isplay = 0;
        }

        else {


            switch(key_code) { //uses a case statement for each individual touch sensor
                case 1:
                    uLCD.cls();
                    uLCD.locate(6,6);
                    uLCD.text_width(5);
                    uLCD.text_height(5);
                    uLCD.printf("C");
                    //printf("%d", key_code);

                    myRGBled.write(0.0,0.0,1.0 );
                    mySpeaker.PlayNote(261.6256 * octave, 0.5, volume);
                    break;
                case 2:
                    uLCD.cls();
                    uLCD.locate(6,6);
                    uLCD.text_width(5);
                    uLCD.text_height(5);
                    uLCD.printf("CS");
                    myRGBled.write(0.0,0.0,1.0 );
                    
                    mySpeaker.PlayNote(277.1826 * octave, 0.5, volume);
                    break;
                case 3:
                    uLCD.cls();
                    uLCD.locate(6,6);
                    uLCD.text_width(5);
                    uLCD.text_height(5);
                    uLCD.printf("D");
                    myRGBled.write(1.0,0.0,0.0 );
                    
                    mySpeaker.PlayNote(293.6648 * octave, 0.5, volume);
                    break;
                case 4:
                    uLCD.cls();
                    uLCD.locate(6,6);
                    uLCD.text_width(5);
                    uLCD.text_height(5);
                    uLCD.printf("DS");
                    myRGBled.write(1.0,0.0,0.0 );
                    mySpeaker.PlayNote(311.1270 * octave, 0.5, volume);
                    break;
                case 5:
                    uLCD.cls();
                    uLCD.locate(6,6);
                    uLCD.text_width(5);
                    uLCD.text_height(5);
                    uLCD.printf("E");
                    myRGBled.write(0.0,1.0,0.0 );
                    mySpeaker.PlayNote(329.6276 * octave, 0.5, volume);
                    break;
                case 6:
                    uLCD.cls();
                    uLCD.locate(6,6);
                    uLCD.text_width(5);
                    uLCD.text_height(5);
                    uLCD.printf("F");
                    myRGBled.write(0.0,1.0,0.0 );
                    mySpeaker.PlayNote(349.2282 * octave, 0.5, volume);
                    break;
                case 7:
                    uLCD.cls();
                    uLCD.locate(6,6);
                    uLCD.text_width(5);
                    uLCD.text_height(5);
                    uLCD.printf("FS");
                    myRGBled.write(0.0,0.0,1.0 );
                    mySpeaker.PlayNote(369.9944 * octave, 0.5, volume);
                    break;
                case 8:
                    uLCD.cls();
                    uLCD.locate(6,6);
                    uLCD.text_width(5);
                    uLCD.text_height(5);
                    uLCD.printf("G");
                    myRGBled.write(0.0,0.0,1.0 );
                    mySpeaker.PlayNote(391.9954 * octave, 0.5, volume);
                    break;
                case 9:
                    uLCD.cls();
                    uLCD.locate(6,6);
                    uLCD.text_width(5);
                    uLCD.text_height(5);
                    uLCD.printf("GS");
                    myRGBled.write(1.0,0.0,0.0 );
                    mySpeaker.PlayNote(415.3047 * octave, 0.5, volume);
                    break;
                case 10:
                    uLCD.cls();
                    uLCD.locate(6,6);
                    uLCD.text_width(5);
                    uLCD.text_height(5);
                    uLCD.printf("A");
                    myRGBled.write(1.0,0.0,0.0 );
                    mySpeaker.PlayNote(440.0 * octave, 0.5, volume);
                    break;
                case 11:
                    uLCD.cls();
                    uLCD.locate(6,6);
                    uLCD.text_width(5);
                    uLCD.text_height(5);
                    uLCD.printf("AS");
                    myRGBled.write(0.0,1.0,0.0 );
                    mySpeaker.PlayNote(466.1638 * octave, 0.5, volume);
                    break;
                case 12:
                    uLCD.cls();
                    uLCD.locate(6,6);
                    uLCD.text_width(5);
                    uLCD.text_height(5);
                    uLCD.printf("B");
                    myRGBled.write(0.0,1.0,0.0 );
                    mySpeaker.PlayNote(493.8833 * octave, 0.5, volume);
                    break;
            }
        }
        Thread::wait(200);
    }
}



