#include "RpcMPL3115A2.h"

RpcMPL3115A2::RpcMPL3115A2(PinName sda, PinName scl, const char *name) : 
    RPC(name),
    chip(sda, scl) 
{
}

int RpcMPL3115A2::id(void) {
    return chip.getId();
}

void RpcMPL3115A2::setMode(int mode) {
    chip.setDataMode(static_cast<MPL3115A2::DataMode>(mode));
}

int RpcMPL3115A2::getMode(void) {
    return chip.getDataMode();
}

void RpcMPL3115A2::setOverSampling(int rate) {
    chip.setOverSampling(rate);
}

int RpcMPL3115A2::getOverSampling() {
    return chip.getOverSampling();
}

void RpcMPL3115A2::read(Arguments *args, Reply *reply) {
    float pres;
    float temp;
    
    chip.getReadings(pres, temp);
    
    reply->putData(pres);
    reply->putData(temp);
}


const struct rpc_method *RpcMPL3115A2::get_rpc_methods() {
    static const rpc_method rpc_methods[] = {
        {"id", rpc_method_caller<int, RpcMPL3115A2, &RpcMPL3115A2::id>},
        {"read", rpc_method_caller<RpcMPL3115A2, &RpcMPL3115A2::read> },
        {"writeMode", rpc_method_caller<RpcMPL3115A2, int, &RpcMPL3115A2::setMode> },
        {"readMode", rpc_method_caller<int, RpcMPL3115A2, &RpcMPL3115A2::getMode> },
        {"writeSamples", rpc_method_caller<RpcMPL3115A2, int, &RpcMPL3115A2::setOverSampling> },
        {"readSamples", rpc_method_caller<int, RpcMPL3115A2, &RpcMPL3115A2::getOverSampling> },
        RPC_METHOD_SUPER(RPC)
    };
    
    return rpc_methods;
}

const char *RpcMPL3115A2::get_rpc_class_name() {
    return get_rpc_class()->name;
}

struct rpc_class *RpcMPL3115A2::get_rpc_class() {
    static const rpc_function funcs[] = {
        {"new", rpc_function_caller<const char*, PinName, PinName, const char*, &RPC::construct<RpcMPL3115A2, PinName, PinName, const char*> >},
        RPC_METHOD_END
    };
    static rpc_class c = {"MPL3115A2", funcs, NULL};
    
    return &c;
}
