#include "mbed.h"
#include <I2CEeprom.h>

DigitalOut myled(LED1);

struct Info {
    char name[32];
    int age;
    float score;
};
    
const char *convBool(bool value) { return value ? "true" : "false"; }

int main() {
    I2CEeprom memory(I2C_SDA,I2C_SCL, 0xAE, 32, 0);
    if (memory.write(1, 'Z') != 1) {
        printf("Write failed\n\r");
    }
    
    char value;
    if (memory.read(1, value) == 0) {
        printf("Read failed\n\r");
    } else {
        printf("Value read [%c] valid %s\n\r", value, convBool(value == 'Z'));
    }

    const char *pat = "Abcdefghijklmnopqrstuvwxyz";    
    if (memory.write(50, pat, 27) != 27) {
        printf("Write failed\n\r");
    }
    
    if (memory.read(50, value) != 1) {
        printf("Read failed\n\r");
    } else {
        printf("First char read [%c]\n\r", value);
    
        char buffer[28] = {'A', '\0' };
        if (memory.read(50, buffer, 27) != 27) {
            printf("Read failed\n\r");
        } else {
            printf("Value read [%s] valid %s\n\r", buffer, convBool(strcmp(buffer, pat) == 0));
        }
    }
    
    memory.fill(0, 'A', 512);
    char small[33];
    if (memory.read(10, small, 32) != 32) {
        printf("Read failed\n\r");
    } else {
        bool same = true;
        for (int count = 0; count != 32; ++count) {
            same &= small[count] == 'A';
        }
        printf("Value read [%.32s] valid %s\n\r", small, convBool(same));
    }
    
    const char *bigPat = "123456789A123456789B123456789C123456789D123456789E123456789F123456789G123456789H123456789a123456789b123456789c123456789d123456789e123456789f123456789g123456789h123456789A123456789B123456789C123456789D123456789E123456789F123456789G123456789H123456789a123456789b123456789c123456789d123456789e123456789f123456789g123456789h";
    size_t patSize = strlen(bigPat) + 1;
    if (!memory.write(42, bigPat, patSize)) {
        printf("Write failed\n\r");
    }

    char bigBuffer[512] = {'A', '\0' };
    if (memory.read(42, bigBuffer, patSize) != patSize) {
        printf("Read failed\n\r");
    } else {
        printf("Value read [%s]\n\r", bigBuffer);
        printf("Same is %s\n\r", convBool(strcmp(bigPat, bigBuffer) == 0));
    }
    
    int values[4] = { 1, 2, 3, 4};
    if (memory.write(4, values) != sizeof(values)) {
        printf("Write failed\n\r");
    }
    
    int newValues[4];
    if (memory.read(4, newValues) != sizeof(values)) {
        printf("Read failed\n\r");
    }
    
    for (int count = 0; count != 4; ++count) {
        printf("Values[%d] = %d\n\r", count, newValues[count]);
    }
    
    Info foo[] = {
        { "Bill", 18, 2.3 },
        { "Bert", 21, 4.5 },
        { "Mary", 19, 7.5 }
    };
    
    if (!memory.write(100, foo)) {
        printf("Write failed\n\r");
    }
    
    Info bar[3];
    if (!memory.read(100, bar)) {
        printf("Read failed\n\r");
    }
    for (int count = 0; count != 3; ++count) {
        printf("name %s, age %d, score %f\n\r", bar[count].name, bar[count].age, bar[count].score);
    }
    
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
