/*
 * WS2812 tape led IC
 */
#include "mbed.h"
#include "LEDStrip.h"
#include <stdint.h>
#include "LEDStripFunctions.h"

//Serial pc(USBTX, USBRX);
DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);

extern "C"
void HardFault_Handler() {
    printf("Hard Fault!\r\n");
    exit(-1);
}

int main() {
    uint32_t i;
    int j, k = 0;
    
    int numLEDs = 59;
  //  pc.baud(115200);
    tapeInit(0, numLEDs);
    led1 = 1;

   // pc.printf("led\r\n");
    int color_on = (0xff << 16) | (0xff << 8) | (0xff);

    uint32_t colors[numLEDs];
    /*
    for (k = 0; k < numLEDs; k++)
    {
        colors[k] = (k*260000);
    }*/
    
    setEveryMod(colors, 0xff, 6, 0, numLEDs);
    setEveryMod(colors, (0xff<<8), 6, 1, numLEDs);
    setEveryMod(colors, (0xff<<16), 6, 2, numLEDs);
    setEveryMod(colors, (0xff<<16)|(0xff<<8), 6, 3, numLEDs);
    setEveryMod(colors, (0xff<<8)|(0xff), 6, 4, numLEDs);
    setEveryMod(colors, (0xff<<16)|(0xff), 6, 5, numLEDs);
    scaleBrightness(colors, 8, numLEDs);

    for (;;) {
            led1 = 1;           
            
            
            
            for(i = 0; i < 59; i++);
            {
                
                shiftAllFwd(colors, numLEDs);   
                setAll(colors, numLEDs);
                led1 = 0;
                tapeSend();
                wait_ms(500);
                
                shiftAllFwd(colors, numLEDs);                
                setAll(colors, numLEDs);
                led1 = 1;
                tapeSend();
                wait_ms(500);
            }
    }
}
