#include "mbed.h"
#include "LEDStrip.h"
#include <stdint.h>


void setAll(uint32_t *buffer, int n)
{
    int i;
    for (i = 0; i < n; i++)
    {
        tapeSet(i, buffer[i]);   
    }
}

void setAllOneColor(uint32_t color, int n)
{
    int i;
    for (i = 0; i < n; i++)
    {
        tapeSet(i, color);   
    }   
}

void shiftAllFwd(uint32_t *buffer, int n)
{
    int i;
    uint32_t temp = buffer[n];
    for (i = n; i > 0; i--)
    {        
        buffer[i] = buffer[i-1];
    }
    buffer[0] = temp;
}

void shiftAllRev(uint32_t *buffer, int n)
{
    int i;
    uint32_t temp = buffer[0];
    for (i = 0; i <= n-1; i++)
    {        
        buffer[i] = buffer[i+1];
    }
    buffer[n] = temp;
}


void setEveryMod(uint32_t * buffer, uint32_t color, int mod, int start, int n)
{
    int i;
    for (i = 0; i < n; i ++)
    {
        if ((i >= start) && ((i - start) % mod == 0)) buffer[i] = color;   
    }   
}


void scaleBrightness(uint32_t *buffer, int divider, int n)
{
    int i, r, g, b;
    for (i = 0; i < n; i++)
    {
        r = (buffer[i] >> 16) & 0xff;
        g = (buffer[i] >> 8 ) & 0xff;
        b = (buffer[i]      ) & 0xff;
        r /= divider;
        g /= divider;
        b /= divider;
        buffer[i] = (r << 16) | (g << 8) | (b);
    } 
}

void setPixelRGB(int pixel, int r, int g, int b)
{
       
    int pix = (r << 16) | (g << 8) | (b);
    tapeSet(pixel, pix);
}