/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "SharpLCD.hpp"

void
SharpLCD::writeBuffer(const uint8_t *buffer, unsigned len)
{
    chipSelect = 1;
    while (len--) {
        spi.write(*buffer++);
    }
    chipSelect = 0;
}

void
SharpLCD::clear(void)
{
    const uint8_t buf[2] = {M2_FLAG, DUMMY8};

    writeBuffer(buf, sizeof(buf));
}

void
SharpLCD::drawFrameBuffer(const FrameBuffer &fb)
{
    writeBuffer(fb.getBuffer(), SIZEOF_FRAMEBUFFER_FOR_ALLOC);
}

void
SharpLCD::toggleVCOM(void)
{
    static bool frameInversion = false;
    uint8_t buf[2] = {0, DUMMY8};

    uint8_t mode = 0x0;
    if (frameInversion) {
        mode |= M1_FLAG;
    }
    frameInversion = !frameInversion; /* toggle frameInversion in
                                       * preparation for the next call */

    buf[0] = mode;
    writeBuffer(buf, sizeof(buf));
}
