#include "mbed.h"
#include "SDFileSystem.h"
#include "uLCD_4DGL.h"
//#include "VS1002.h"

DigitalOut myled(LED1);

uLCD_4DGL uLCD(p28, p27, p30);
 
DigitalIn Dreq(p26);
DigitalOut XDCS(p25);
DigitalOut reset(p23);
DigitalOut XCS(p22);
 
SPI mp3Board(p11, p12, p13); // mosi, miso, sclk
SDFileSystem sd(p5, p6, p7, p8, "sd"); // DI, DO, SCK, CS

int readOut;


int main() {
    mp3Board.frequency(12000000);
    //set register
    reset = 1;
    XDCS = 1; //1) Always keep XDCS at logical 1.
    XCS = 0; //2) Set XCS to 0, 
    mp3Board.write(0x02); //0x02 is the write opcode
    mp3Board.write(0x00); //0x00 is the address of the sci mode register
    mp3Board.write(0x0A); //0x0A (11 in dec) is the SM_SDINEW bit    //send SCI command to set SCI_MODE with SM_SHARED and SM_SDINEW set to 1, 
    XCS = 1;    //then set XCS back to 1.
    
    //read register
    XCS = 0;
    mp3Board.write(0x03); //"read" opcode
    readOut = mp3Board.write(0x00); //register address to read from. Dumps read output to readOut
    uLCD.printf("%2D",readOut); //print readOut to LCD

}
