#ifndef __CONFIG_ME_H_
#define __CONFIG_ME_H_

// User must set these for own context:

#define BUF_SIZE_FOR_N_MAX_SOCKREAD (10)
#define MAX_WNC_SOCKREAD_PAYLOAD (1500)

// This is the server's base server name.  Example "www.google.com"
// Note that when you Fork a FLOW, it will typically assign  either
// "run-east.att.io" or "run-west.att.io", so be sure to check this.
static const char * MY_SERVER_NAME       = "run-west.att.io";  //  CHECK ME, might be different

//This is for normal HTTP.  If you want to use TCP to a specific port, change that here:
static const char * MY_PORT_STR         = "0000";       // CHANGE ME

// Only used if you program void GenerateModemString() to use them and send HTTP
// These are FLOW fields from the Endpoints tab:
#define FLOW_BASE_PATH                   "/..../in/flow"  // CHANGE ME
#define FLOW_INPUT_NAME                 "/buttons"
// The full URL will be "http://"+MY_SERVER_NAME+":"+MY_PORT_STR+FLOW_PATH_PATH+FLOW_INPUT_NAME

// Unless you want to use a different protocol, this field should be left as is:
#define FLOW_URL_TYPE                   " HTTP/1.1\r\nHost: "

// This identifier specifies with which FLOW device you are communicating. 
// If you only have one devive there then you can just leave this as is.
// Once your FLOW device has been initialized (Virtual Device Initialize clicked),
// the Virtual Device will show up in M2X.  This is its "DEVICE SERIAL" field
#define M2X_DEVICE_SERIAL                "starterkit001"

// This constant defines how often sensors are read and sent up to FLOW
#define SENSOR_UPDATE_INTERVAL_MS       5000; //5 seconds

// This is the APN name for the cellular network, you will need to change this, check the instructions included with your SIM card kit:
static const char * MY_APN_STR          = "m2m.com.attz";

#endif
