#include "mbed.h"
#include <cctype>
#include <string>
#include "config_me.h"
#include "cell_modem.h"
#include "hardware.h"

I2C i2c(PTC11, PTC10);    //SDA, SCL -- define the I2C pins being used
MODSERIAL pc(USBTX, USBRX, 256, 256); // tx, rx with default tx, rx buffer sizes
MODSERIAL mdm(PTD3, PTD2, 4096, 4096);
DigitalOut led_green(LED_GREEN);
DigitalOut led_red(LED_RED);
DigitalOut led_blue(LED_BLUE);

// interrupts for buttons
InterruptIn sw3(SW3);
InterruptIn sw2(SW2);

// flag - must be volatile as changes within ISR
// g_ prefix makes it easier to distinguish it as global
volatile int g_sw3_flag = 0;
volatile int g_sw2_flag = 0;

// SW2 event-triggered interrupt
// ISR = interrupt service routine
// down = button was pushed down/falling
// up = button was released/rising
void sw2_isr_down()
{
    g_sw2_flag = 1;   // set flag in ISR
}

void sw2_isr_up()
{
    g_sw2_flag = 0;
}

// SW3 event-triggered interrupt
void sw3_isr_down()
{
    g_sw3_flag = 1;   // set flag in ISR
}

void sw3_isr_up()
{
    g_sw3_flag = 0;
}

void GenerateModemString(char * modem_string, char btn1, char btn2)
{
    sprintf(modem_string, "serial:%s button1:%c button2:%c\r\n",
            M2X_DEVICE_SERIAL, btn1, btn2
           );
    
    // HTTP method
    /*sprintf(modem_string, "GET %s%s?serial=%s&button1=%c&button2=%c %s%s\r\n\r\n",
        FLOW_BASE_PATH, FLOW_INPUT_NAME, M2X_DEVICE_NAME,
        btn1, btn2,
        FLOW_URL_TYPE, MY_SERVER_NAME); */

} //GenerateModemString


//********************************************************************************************************************************************
//* Set the RGB LED's Color
//* LED Color 0=Off to 7=White.  3 bits represent BGR (bit0=Red, bit1=Green, bit2=Blue)
//********************************************************************************************************************************************
void SetLedColor(unsigned char ucColor)
{
    //Note that when an LED is on, you write a 0 to it:
    led_red = !(ucColor & 0x1); //bit 0
    led_green = !(ucColor & 0x2); //bit 1
    led_blue = !(ucColor & 0x4); //bit 2
} //SetLedColor()

//********************************************************************************************************************************************
//* Process the JSON response.  In this example we are only extracting a LED color.
//********************************************************************************************************************************************
bool parse_JSON(char* json_string)
{
    char* beginquote;
    char token[] = "\"LED\":\"";
    beginquote = strstr(json_string, token );
    if ((beginquote != 0)) {
        char cLedColor = beginquote[strlen(token)];
        PRINTF(GRN "LED Found : %c" DEF "\r\n", cLedColor);
        switch(cLedColor) {
            case 'O': {
                //Off
                SetLedColor(0);
                break;
            }
            case 'R': {
                //Red
                SetLedColor(1);
                break;
            }
            case 'G': {
                //Green
                SetLedColor(2);
                break;
            }
            case 'Y': {
                //Yellow
                SetLedColor(3);
                break;
            }
            case 'B': {
                //Blue
                SetLedColor(4);
                break;
            }
            case 'M': {
                //Magenta
                SetLedColor(5);
                break;
            }
            case 'T': {
                //Turquoise
                SetLedColor(6);
                break;
            }
            case 'W': {
                //White
                SetLedColor(7);
                break;
            }
            default: {
                break;
            }
        } //switch(cLedColor)
        return true;
    } else {
        return false;
    }
} //parse_JSON

void send_button_data(char btn1, char btn2)
{
    char modem_string[512];
    GenerateModemString(&modem_string[0], btn1, btn2);
    char myJsonResponse[512];
    if (cell_modem_Sendreceive(&modem_string[0], &myJsonResponse[0])) {
        if (true) {
            //ledOnce = 1;
            SetLedColor(0x2); //Green
        }
        parse_JSON(&myJsonResponse[0]);
    }
}

int main()
{
    //static unsigned ledOnce = 0;

    pc.baud(115200);
    PRINTF(GRN "Hello World from the Cellular IoT Kit!\r\n");
    PRINTF(GRN "Cellular IoT Buttons!\r\n\r\n");

    // SW have a pull-up resistor, so the pin will be at 3.3 V by default
    // and fall to 0 V when pressed. We therefore need to look for a falling edge
    // on the pin to fire the interrupt
    sw3.fall(&sw3_isr_down);
    sw3.rise(&sw3_isr_up);
    sw2.fall(&sw2_isr_down);
    sw2.rise(&sw2_isr_up);
    // since SW have an external pull-up, we should disable to internal pull-down
    // resistor that is enabled by default using InterruptIn
    sw3.mode(PullNone);
    sw2.mode(PullNone);

    // Set LED to RED until init finishes
    SetLedColor(0x1); //Red
    // Initialize the modem
    PRINTF("\r\n");
    cell_modem_init();
    // Set LED BLUE for partial init
    SetLedColor(0x4); //Blue

    // Send and receive data perpetually
    while(1) {
        if (g_sw3_flag) {
            printf("%s\n","SW3 Button");
            led_green = 0;
            send_button_data('0','1');
        } else {
            led_green = 1;
        }

        if (g_sw2_flag) {
            printf("%s\n","SW2 Button");
            led_blue = 0;
            send_button_data('1','0');
        } else {
            led_blue = 1;
        }

        // put the MCU to sleep until an interrupt wakes it up
        sleep();
    } //forever loop
}
