#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"

uLCD_4DGL uLCD(p9, p10, p11);
DigitalIn flap_button(p30);
AnalogIn ain(p20);

int bird_lo_addr = 0x7801;
int y_pos = 63, old_ypos = 63;
int vel = 1;
int state = 0;
int score = 0;

// wall_1
int wall_x_pos1 = 128, opening_y_pos1;

// wall 2
int wall_x_pos2, opening_y_pos2;

// wall 3
int wall_x_pos3, opening_y_pos3; 

void draw_frame() {
    
    switch (state) {
        case 0:
            uLCD.locate(0, 6);
            uLCD.printf("PRESS 2 START");
            break;
        
        case 1:
            // Draw blue rectangle over old bird position 
            uLCD.set_sector_address(0x001D, 0x7803);
            uLCD.display_image(20, old_ypos);
            
            if(wall_x_pos1 > -21 && wall_x_pos1 < 128){
                // draw wall 1
                if(wall_x_pos1 < 0){
                    //uLCD.filled_rectangle(0, 0, wall_x_pos1 + 19, 127, RED);
                    //uLCD.filled_rectangle(0, opening_y_pos1, wall_x_pos1 + 19, opening_y_pos1 + 39, BLUE);
                    uLCD.filled_rectangle(wall_x_pos1 + 20, 0, wall_x_pos1 + 21, 127, BLUE);
                } else if (wall_x_pos1 > 119){
                    uLCD.filled_rectangle(wall_x_pos1, 0, wall_x_pos1+1, opening_y_pos1-1, RED);
                    uLCD.filled_rectangle(wall_x_pos1, opening_y_pos1+40, wall_x_pos1+1, 127, RED);
                } else {
                    uLCD.filled_rectangle(wall_x_pos1, 0, wall_x_pos1+1, opening_y_pos1-1, RED);   
                    uLCD.filled_rectangle(wall_x_pos1, opening_y_pos1+40, wall_x_pos1+1, 127, RED);   
                    uLCD.filled_rectangle(wall_x_pos1 + 20, 0, wall_x_pos1 + 21, 127, BLUE);
                }
            }
            
            if(wall_x_pos2 > -21 && wall_x_pos2 < 128){
                // draw wall 1
                if(wall_x_pos2 < 0){
                    //uLCD.filled_rectangle(0, 0, wall_x_pos2 + 19, 127, RED);
                    //uLCD.filled_rectangle(0, opening_y_pos2, wall_x_pos2 + 19, opening_y_pos2 + 39, BLUE);
                    uLCD.filled_rectangle(wall_x_pos2 + 20, 0, wall_x_pos2 + 21, 127, BLUE);
                } else if (wall_x_pos2 > 119){
                    uLCD.filled_rectangle(wall_x_pos2, 0, wall_x_pos2+1, opening_y_pos2-1, RED);
                    uLCD.filled_rectangle(wall_x_pos2, opening_y_pos2+40, wall_x_pos2+1, 127, RED);
                } else {
                    uLCD.filled_rectangle(wall_x_pos2, 0, wall_x_pos2+1, opening_y_pos2-1, RED);   
                    uLCD.filled_rectangle(wall_x_pos2, opening_y_pos2+40, wall_x_pos2+1, 127, RED);   
                    uLCD.filled_rectangle(wall_x_pos2 + 20, 0, wall_x_pos2 + 21, 127, BLUE);
                }
            }
            
            if(wall_x_pos3 > -21 && wall_x_pos3 < 128){
                // draw wall 3
                if(wall_x_pos3 < 0){
                    uLCD.filled_rectangle(wall_x_pos3 + 20, 0, wall_x_pos3 + 21, 127, BLUE);
                } else if (wall_x_pos3 > 119){
                    uLCD.filled_rectangle(wall_x_pos3, 0, wall_x_pos3+1, opening_y_pos3-1, RED);
                    uLCD.filled_rectangle(wall_x_pos3, opening_y_pos3+40, wall_x_pos3+1, 127, RED);
                } else {
                    uLCD.filled_rectangle(wall_x_pos3, 0, wall_x_pos3+1, opening_y_pos3-1, RED);   
                    uLCD.filled_rectangle(wall_x_pos3, opening_y_pos3+40, wall_x_pos3+1, 127, RED);   
                    uLCD.filled_rectangle(wall_x_pos3 + 20, 0, wall_x_pos3 + 21, 127, BLUE);
                }
            }
            
            // Draw bird at current position
            uLCD.set_sector_address(0x001D, bird_lo_addr);
            uLCD.display_image(20, y_pos);
            
            break;
            
        case 2:
            uLCD.filled_rectangle(0, 0, 127, 127, BLACK);
            uLCD.locate(0, 6);
            uLCD.printf("GAME OVER");
            uLCD.locate(0, 7);
            uLCD.printf("SCORE: %d", score);
            break;
    }
}

void update_frame() {
    // Update bird position
    old_ypos = y_pos;
    y_pos += vel;
    
    if (y_pos > 122) {
        y_pos = 122;
    } else if (y_pos < 0) {
        y_pos = 0;
    }
    
    if (wall_x_pos1 <= 26 && wall_x_pos1 > 0) {
        if (y_pos < opening_y_pos1 || y_pos+5 > opening_y_pos1+39) {
            state = 2;
            wait(3);
        }
    }
    
    if (wall_x_pos2 <= 26 && wall_x_pos2 > 0) {
        if (y_pos < opening_y_pos2 || y_pos+5 > opening_y_pos2+39) {
            state = 2;
            wait(3);
        }
    }
    
    if (wall_x_pos3 <= 26 && wall_x_pos3 > 0) {
        if (y_pos < opening_y_pos3 || y_pos+5 > opening_y_pos3+39) {
            state = 2;
            wait(3);
        }
    }
    
    // Update bird velocity
    if (!flap_button) {
        // Toggle bird flap
        bird_lo_addr ^= 0x3;
    
        vel--;
        if (vel < -5) vel = -5;
    } else {
        vel++;
        if (vel > 5) vel = 5;
    }
    
    // Update wall positions
    if(wall_x_pos1 > -21){
        wall_x_pos1 -= 2;
    } else {
        wall_x_pos1 = wall_x_pos3 + 80 - (rand() % score);
        opening_y_pos1 = (int)(ain*1000.0) % 46 + 20;
        score++;
    }
    
    if(wall_x_pos2 > -21){
        wall_x_pos2 -= 2;
    } else {
        wall_x_pos2 = wall_x_pos1 + 80 - (rand() % score);
        opening_y_pos2 = (int)(ain*1000.0) % 46 + 20;
        score++;
    }
    
    if(wall_x_pos3 > -21){
        wall_x_pos3 -= 2;
    } else {
        wall_x_pos3 = wall_x_pos2 + 80 - (rand() % score);
        opening_y_pos3 = (int)(ain*1000.0) % 46 + 20;
        score++;
    }
}

int main() {    
    flap_button.mode(PullUp);
    
    uLCD.baudrate(3000000);
    uLCD.cls();
    uLCD.filled_rectangle(0, 0, 127, 127, BLACK);
    uLCD.media_init();
    
    opening_y_pos1 = rand() % 46 + 20;
    opening_y_pos2 = rand() % 46 + 20;
    opening_y_pos3 = rand() % 46 + 20;
    
    wall_x_pos2 = wall_x_pos1 + 80 - (rand() % 5);
    wall_x_pos3 = wall_x_pos2 + 80 - (rand() % 5);
    
    // Bird is 6 rows, 7 cols
    
    while (1) {
        draw_frame();
        
        if (state == 1) {
            update_frame();
        } else if (state == 0 && !flap_button) {
            uLCD.filled_rectangle(0, 0, 127, 127, BLUE);
            state = 1;   
        }
        
        wait_ms(50);
    }
}
