#include "mbed.h"
#include <stdio.h>

#define BASE_TIEMPO 0.0001

//Declaración de estados
enum{
    NORMAL,
    Juego1,
    Juego2,
    Juego3,
    Gano,
    Perdio
};

//Declaración de entradas y salidas
DigitalIn SW(D4);
DigitalIn C1(PTC7);
DigitalIn C2(PTC0);
DigitalIn C3(PTC3);
DigitalIn C4(PTC4);
DigitalOut ROJO(D2);
DigitalOut VERDE(D3);
DigitalOut BUZZER(D5);
DigitalOut A(PTC17);
DigitalOut B(PTC16);
DigitalOut C(PTC13);
DigitalOut D(PTC12);
DigitalOut BL(D8);
DigitalOut DISPLAY1(D9);
DigitalOut DISPLAY2(D10);

//Declaración de variables
Ticker tick;
Serial pc(USBTX, USBRX);
int segundos = 0 , music = 0 ,notime = 0;
int t = 0;
int E = 0;
int Cable = 4;
int MUSICA = 0;
int GREEN = 0 , RED = 0, BLINK = 0;
int valor = 0;
int mux_display = 0;

//Declaración de funciones
void bomba();
void display(int);
void secuencia();
void Interrupt(){
    segundos++;
    mux_display++;
    music++;
    //El buzzer modifica su oscilación dependiendo de MUSICA, siempre y cuando se encuentre en partida. 
    if(music >= 30000 - 9000*MUSICA && MUSICA >= 1 && MUSICA <= 3){
        BUZZER ? BUZZER = 0 : BUZZER = 1;
        music =0;
    }else
    BUZZER = 0;
    //Cada medio segundo hago oscilar los leds y el display, solo si RED o GREEN se activan
    if(segundos == 5000 || segundos == 10000){
        if(GREEN)
            VERDE ? (VERDE = 0) : (VERDE = 1);
        else
            VERDE = 0;
        if(RED)
            ROJO ? (ROJO = 0) : (ROJO = 1);
        else
            ROJO = 0;
        if(BLINK)
            BL ? (BL = 0) : (BL = 1);
        else
            BL = 1;
    }
    //Utilizo la siguiente secuencia para marcar los pasos de 1s (t)
    if(segundos >= 10000 ){
        if(t > 0)
            t--;
        segundos = 0;
    }
    //Utilizo la siguiente secuencia para marcar los pasos de 1s (t)
    if(mux_display >= 41 ){     
        if(BLINK)
            display(valor); 
        else
            display(t);
        mux_display = 0;
    }
}

int main(){
    tick.attach(&Interrupt , BASE_TIEMPO);
    while(1){
        bomba();
    }
}

void bomba(){
    static int estado = NORMAL;
    //Declaro los estados como se diagramaron en la máquina de estados
    switch(estado){
        case NORMAL:
            if(SW.read() == 1){
                secuencia();
                estado = Juego1;
                t = 70;
                MUSICA = 1;
                RED = 0;
                GREEN = 0;
                pc.printf("El juego esta ahora en marcha. Primeros 30s\n");
            }
            break;
        case Juego1:
            secuencia();
            if(t <= 40){
                estado = Juego2;
                MUSICA = 2;
                pc.printf("La musica se intensifica\n");
            }
            if(E){
                estado = Perdio;
                valor = t;
                t = 10;
                RED = 1;
                MUSICA = 5;
                BLINK = 1;
                pc.printf("Partida terminada, el jugador pierde.\n");
            }
            if(Cable == 0){
                estado = Gano;
                GREEN = 1;
                MUSICA = 4;
                BLINK = 1;
                valor = t;
                t = 10;
                pc.printf("Partida terminada, el jugador gana.\n");
            }
            break;
        case Juego2:
            secuencia();
            if(t <= 20){
                estado = Juego3;
                MUSICA = 3;
                pc.printf("Queda poco tiempo\n");
            }
            if (E){
                estado = Perdio;
                RED = 1;
                MUSICA = 5;
                BLINK = 1;
                valor = t;
                t=10;
                pc.printf("Partida terminada, el jugador pierde.\n");
            }
            if(Cable == 0){
                estado = Gano;
                GREEN = 1;
                MUSICA = 4;
                BLINK = 1;
                valor = t;
                t = 10;
                pc.printf("Partida terminada, el jugador gana.\n");
            }
            break;
        case Juego3:
            secuencia();
            if(t <= 10 || E){
                estado = Perdio;
                MUSICA = 5;
                RED = 1;
                BLINK = 1;
                valor = t;
                pc.printf("Partida terminada, el jugador pierde.\n");
            }
            if(t <= 10)
                notime = 1;
            if(Cable == 0){
                estado = Gano;
                GREEN = 1;
                MUSICA = 4;
                BLINK = 1;
                valor = t;
                t = 10;
                pc.printf("Partida terminada, el jugador gana.\n");
            }
            break;
        case Gano:
            if(t == 0){
                estado = NORMAL;
                Cable = 4;
                MUSICA = 0;
                BLINK = 0;
                GREEN = 0;
                pc.printf("El juego se encuentra listo para comenzar.\n");
            }
            break;
        case Perdio:
            if(t == 0){
                estado = NORMAL;
                Cable = 4;
                E = 0;
                MUSICA = 0;
                BLINK = 0;
                RED = 0;
                pc.printf("El juego se encuentra listo para comenzar.\n");
            }
        break;
        default:
            estado = NORMAL;
    }
}

//Funcion de control de multiplexado
void display(int x){
    char decenas;
    char unidades;
    if(x > 10){
        decenas = (x-10)/10;
        unidades = (x-10)%10;
    }else{
        decenas = 0;
        unidades = 0;
    }
    static char estado = 0;
    //estado indica el display a utilizar.
    //En ambos casos se toma bit a bit el número (unidad o decena) y se la inserta en el CD4511 mediante A, B, C y D
    //Los displays se apagan por un breve momento mientras se configura el Cd4511
    if(estado == 0){
        DISPLAY2 = 0;
        A = (decenas & 0b1000)>>3;
        B = (decenas & 0b100)>>2;
        C = (decenas & 0b10)>>1;
        D = decenas & 1;
        DISPLAY1 = 1;
        estado = 1;
    }else if(estado == 1){
        DISPLAY1 = 0;
        A = (unidades & 0b1000)>>3;
        B = (unidades & 0b100)>>2;
        C = (unidades & 0b10)>>1;
        D = unidades & 1;
        DISPLAY2 = 1;
        estado = 0;
    }
}

//Funcion que se encarga de modificar la secuencia y su correcto seguimiento durante la partida.
void secuencia(){
    static int flag = 0 , flagc1 = 0 , flagc2 = 0 , flagc3 = 0 , flagc4 = 0;
    static int secuencia[4];
    if (flag == 0){
        flagc1 = 0;
        flagc2 = 0;
        flagc3 = 0;
        flagc4 = 0;
        secuencia[0]= 0;
        secuencia[1]= 0;
        secuencia[2]= 0;
        secuencia[3]= 0;
        
        //Declaro las variables dentro de la secuencia hasta que tenga un ejemplar de cada numereo del 1 al 4
        for(int i = 0 ; i < 4 ;){
            secuencia[i] = rand() % 4 + 1;
            for(int j = i - 1 ; j >= 0 ; j--){
                if (secuencia[i] == secuencia[j]){
                    i--;
                    break;
                    }
            }
            i++;
        }
        pc.printf("LA SECUENCIA A REPRODUCIR ES %d %d %d %d\n" , secuencia[0] , secuencia[1] , secuencia[2] , secuencia[3]);
        flag++;
    }else{
        //Cada cable tiene su propio número asignado. Cuando lo desconecto
        //ese código debe conincidir con la secuencia, de otro modo será un
        //error. Una vez desactivado se utiliza una variable para descartarlos
        //hatsa la proxima partida.
        if(C1.read() == 1){
            if(secuencia [flag-1] == 1 && !flagc1){
                Cable--;
                flag++;
                flagc1 = 1;
            }else if(!flagc1)
                E = 1;
            }
        if(C2.read() == 1 && !flagc2){
            if(secuencia [flag-1] == 2){
                Cable--;
                flag++;
                flagc2 = 1;
            }else if(!flagc2)
                E = 1;
            }
        if(C3.read() == 1 && !flagc3){
            if(secuencia [flag-1] == 3){
                Cable--;
                flag++;
                flagc3 = 1;
            }else if(!flagc3)
                E = 1;
            }
        if(C4.read() == 1 && !flagc4){
            if(secuencia [flag-1] == 4){
                Cable--;
                flag++;
                flagc4 = 1;
            }else if(!flagc4)
                E = 1;
            }
        //Cuando se terina la secuencia, se comete un error o se acaba el
        // tiempo se vuelve al primer estado flag = 0 
        if (flag == 5 || E == 1 || notime == 1){
            flag = 0;
            notime = 0;
            }
    }
}