#include "mbed.h"
#include "EthernetInterface.h"
#include "C12832.h"
#include "lib_socket.h"

C12832 lcd(p5, p7, p6, p8, p11);

void send_message_UDP(char* buffer, const char* ipAdsress, const int port) {
    
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    
    lcd.cls();
    lcd.locate(0,1);
    lcd.printf("Client IP:%s \n", eth.getIPAddress());
    
    UDPSocket sock;
    sock.init();
    
    Endpoint echo_server;
    echo_server.set_address(ipAdsress, port);
    
    lcd.locate(0,10);
    int m = sock.sendTo(echo_server, buffer, sizeof(buffer));
    lcd.printf("%d bytes of msg '%s' sent\n",m,buffer);
   
    sock.close();
    
    eth.disconnect();
    while(1) {}
}