#include "mbed.h"
#include "ADT7410.h"
#include "SDFileSystem.h"

DigitalOut myled(LED1);
DigitalIn sw1(P1_20);
DigitalIn sw2(P0_1);
DigitalOut sd_en(P1_16, 1);
//DigitalIn sd_dat3(P0_17); // 0x10
//DigitalIn sd_dat2(P1_22); // 0x08
//DigitalIn sd_dat1(P1_14); // 0x04
//DigitalIn sd_dat0(P0_22); // 0x02
//DigitalIn sd_cmd(P0_21);  // 0x01
SDFileSystem fs(P0_21, P0_22, P1_15, P0_17, "sd"); // mosi(CMD), miso(DAT0), sclk(CLK), cs(DAT3)

ADT7410 tempSens1(P0_5, P0_4, 0x90, 100000); // sda, scl

char buffer[50];

int main()
{

    FILE *fp = fopen("/sd/TEST.txt", "w");
    fprintf(fp, "\n\rHello World!\n\r");
    fclose(fp);
    free(fp);

    myled=0;
    tempSens1.reset();
    tempSens1.setConfig(ONE_SPS_MODE);

    // get temperature every two seconds
    while (1) {
        sprintf (buffer, "%f\r\n", tempSens1.getTemp());
        FILE *fp = fopen("/sd/TEST.txt", "a");
        fprintf(fp, buffer);
        fclose(fp);
        free(fp);
        myled=1;
        wait(0.5);
        myled=0;
        wait(0.5);
    }
    
}