#ifndef DOUBLE_BUFFER_H
#define DOUBLE_BUFFER_H

#include "Timer.h"

template <class T, unsigned int S>
class DoubleBuffer {
    public:
        DoubleBuffer();
        void write(T val, long long timestamp);
        T* getReadBuffer();
        int getReadBufferSize();
        long long* getTimestampReadBuffer();
        void swapBuff();
        void init(long long* off, Timer* tim);
        long long db_timestamps[2][S];
    private:
        T buffer[2][S];
        
        int fill_buffer;
        int buffer0_size;
        int buffer1_size;
        long long* off;
        Timer* time;
        bool active;
};

template <class T, unsigned int S>
DoubleBuffer<T, S>::DoubleBuffer() {
    fill_buffer = 0;
    buffer0_size = 0;
    buffer1_size = 0;
    active = false;
}

template <class T, unsigned int S>
void DoubleBuffer<T, S>::init(long long* o, Timer* tim) {
    time = tim;
    off = o;
    active = true;
}

template <class T, unsigned int S>
void DoubleBuffer<T, S>::write(T val, long long timestamp) {
    //long long timestamp = time->read_us() - (*off);
    int buffer_size;
    
    if (!active) {
        return;
    }
    
    if (fill_buffer == 0) {
        if(buffer0_size >= S) {
            return;
        }
        buffer_size = buffer0_size;
        buffer0_size++;
    }
    else {
        if(buffer1_size >= S) {
            return;
        }
        buffer_size = buffer1_size;
        buffer1_size++;
    }
    buffer[fill_buffer][buffer_size] = val;
    db_timestamps[fill_buffer][buffer_size] = timestamp;
}

template <class T, unsigned int S>
T* DoubleBuffer<T, S>::getReadBuffer() {
    if (fill_buffer == 0) {
        return buffer[1];
    }
    else {
        return buffer[0];
    }
}

template <class T, unsigned int S>
long long* DoubleBuffer<T, S>::getTimestampReadBuffer() {
    if (fill_buffer == 0) {
        return db_timestamps[1];
    }
    else {
        return db_timestamps[0];
    }
}

template <class T, unsigned int S>
int DoubleBuffer<T, S>::getReadBufferSize() {
    if (fill_buffer == 0) {
        return buffer1_size;
    }
    else {
        return buffer0_size;
    }
}

template <class T, unsigned int S>
void DoubleBuffer<T, S>::swapBuff() {
    if (fill_buffer == 0) {
        // make sure the fill buffer is empty
        buffer1_size = 0;
        fill_buffer = 1;
    }
    else {
        buffer0_size = 0;
        fill_buffer = 0;
    }
}

#endif
