#include "mbed.h"
#include "KEY_PAD.h"
#include "TextLCD.h"

volatile int row=0;
volatile int col=0;
volatile int key=0;
volatile int step=0;
volatile int code=0;
volatile int pass_code=0;

KEY_PAD::KEY_PAD(PinName stupac3Pin, PinName stupac2Pin, PinName stupac1Pin, PinName red4Pin, PinName red3Pin, PinName red2Pin, PinName red1Pin) : stupac3(stupac3Pin), stupac2(stupac2Pin), stupac1(stupac1Pin), red4(red4Pin), red3(red3Pin), red2(red2Pin), red1(red1Pin) {
    init();
}

void KEY_PAD::init() {
    
    stupci.mode(OpenDrain);
    stupci.mode(PullUp);
    
    red1.mode(PullUp);
    red2.mode(PullUp);
    red3.mode(PullUp);
    red4.mode(PullUp);
    
    red1.fall(this, &get_row1);
    red2.fall(this, &get_row2);
    red3.fall(this, &get_row3);
    red4.fall(this, &get_row4);
}
void KEY_PAD::make_num(){
    switch(step){
        case(0):
            code=code+key*100;
            step++;
        break;
        
        case(1):
            code=code+key*10;
            step++;
        break;
        
        case(2):
            code=code+key;
            step++;
        break;
        
        case(3):
            step++;
        break;
        
        case(4):
            step=0;
            code=0;
        break;
    }
}

void KEY_PAD::make_code(){
    switch(key){
        case(1):
            make_num();
        break;
        
        case(2):
            make_num();
        break;
        
        case(3):
            make_num();
        break;
        
        case(4):
            make_num();
        break;
        
        case(5):
            make_num();
        break;
        
        case(6):
            make_num();
        break;
        
        case(7):
            make_num();
        break;
        
        case(8):
            make_num();
        break;
        
        case(9):
            make_num();
        break;
        
        case(10):
            step=0;
            code=0;
        break;
        
        case(11):
            pass_code=0;
            code=0;
            step=0;
        break;
        
        case(12):
            step=0;
            if(code==123 || code==456 || code==789){
                pass_code=code;
                code=0;
            }
            else{
                step=0;
                code=0;
                lcd.locate(0,3);
                lcd.printf("Pogresna lozinka");             
            }
                //pogresna lozinka
        break;
    }
}


/////////////////////////////////////////////////

void KEY_PAD::shift(){
        stupci = stupci<<1;
        
        stupci = stupci & 0b00000111;
        
        wait_ms(2);
}

void KEY_PAD::get_key(){
  int table[4][3]{{1, 2, 3},
                  {4, 5, 6},
                  {7, 8, 9},
                  {10, 11, 12}};
    
    key=table[row-1][col-1];
    
    row=0;
    col=0;
    
    make_code();
}

void KEY_PAD::get_row1(){
    red1.fall(NULL);
    red2.fall(NULL);
    red3.fall(NULL);
    red4.fall(NULL);
    
    row=1;
    stupci=1;
    
    wait_ms(1);
    
    for(int i=1; i<=3; i++){
        if(red1!=0){
            col=i;
            break;
        }
        shift();
    }
    get_key();
    stupci=0;
}

void KEY_PAD::get_row2(){
    red1.fall(NULL);
    red2.fall(NULL);
    red3.fall(NULL);
    red4.fall(NULL);
    
    row=2;
    stupci=1;
    
    wait_ms(1);
    
    for(int i=1; i<=3; i++){
        if(red2!=0 && i!=3){
            col=i;
            break;
        }
        if(i==3){
            col=3;
            break;
        }
        shift();
    }
    get_key();
    stupci=0;
}

void KEY_PAD::get_row3(){
    red1.fall(NULL);
    red2.fall(NULL);
    red3.fall(NULL);
    red4.fall(NULL);
    
    row=3;
    stupci=1;
    
    wait_ms(1);
    
    for(int i=1; i<=3; i++){
        if(red3!=0 && i!=3){
            col=i;
            break;
        }
        if(i==3){
            col=3;
            break;
        }
        shift();
    }
    get_key();
    stupci=0;
}

void KEY_PAD::get_row4(){
    red1.fall(NULL);
    red2.fall(NULL);
    red3.fall(NULL);
    red4.fall(NULL);
    
    row=4;
    stupci=1;
    
    wait_ms(1);
    
    for(int i=1; i<=3; i++){
        if(red4!=0 && i!=3){
            col=i;
            break;
        }
        if(i==3){
            col=3;
            break;
        }
        shift();
    }
    get_key();
    stupci=0;
}