#include "mbed.h"
/** Initial test of the ultrasonic sensor HC-SR04  */
#include "TextLCD.h"
#include "KEY_PAD.h"
TextLCD lcd(p7, p8, p9, p10, p11, p12);
InterruptIn echo(p5);       // echo pin
DigitalOut trigger(p6);     // trigger pin
Timer timer;                // echo pulsewidth measurement
Timer timer2;
float brzina=0;
float predzadnji;
float vrijeme=0;
float distance = 0;
DigitalOut led1(p28);//crveno
DigitalOut led2(p29);
DigitalOut led3(p30);
/** Start the echo pulsewidth measurement */
void startTimer()
{
    timer.start(); // start the timer
}
/** Stop the echo pulsewidth measurement */
void stopTimer()
{
    timer.stop(); // stop the timer
}

Ticker debounce;

BusInOut stupci(p23, p22, p21);

InterruptIn red1(p27);
InterruptIn red2(p26);
InterruptIn red3(p25);
InterruptIn red4(p24);

BusOut izlaz(LED1, LED2, LED3, LED4);

volatile extern int row=0;
volatile extern int col=0;
volatile extern int key=0;
volatile extern int step=0;
volatile extern int code=0;
volatile extern int pass_code=0;


void enable_keys(){
    red1.fall(&get_row1);
    red2.fall(&get_row2);
    red3.fall(&get_row3);
    red4.fall(&get_row4);
    
    debounce.detach();
}

int main() {
    
    /** configure the rising edge to start the timer */
    echo.rise(&startTimer);

    /** configure the falling edge to stop the timer */
    echo.fall(&stopTimer);
    timer2.start();
    led1=0;
    led2=0;
    led3=1;
    
    stupci.mode(OpenDrain);
    stupci.mode(PullUp);
    
    red1.mode(PullUp);
    red2.mode(PullUp);
    red3.mode(PullUp);
    red4.mode(PullUp);
    
    red1.fall(&get_row1);
    red2.fall(&get_row2);
    red3.fall(&get_row3);
    red4.fall(&get_row4);
    
    while(1) {
            if(red1 == 1 && red2 == 1 && red3 == 1 && red4 == 1){
                if(key>0){
                    izlaz=key;
                    //pc.printf("\n\r %d", code);
                    __enable_irq();
                    debounce.attach(&enable_keys, 0.5); ////////////////////////////////
                }
                key=0;
                wait_ms(100);
            }
            
            switch(pass_code){
                case(0):
                    lcd.locate(0,3);
                    lcd.printf("Unesite mod rada");
                break;
                
                case(123):
                    /** Start the measurement by sending the 10us trigger pulse */
                    trigger = 1;
                    wait_us(10);
                    trigger = 0;
                    /** Wait for the sensor to finish measurement (generate rise and fall interrupts).
                    *  Minimum wait time is determined by maximum measurement distance of 400 cm.
                    *  t_min = 400 * 58 = 23200 us = 23.2 ms */
                    wait(0.2);
                    predzadnji=distance;
                    /** calculate the distance in cm */
                    distance = timer.read() * 1e6 / 58;
                    timer.reset(); // reset the timer to 0
                    brzina=(distance-predzadnji)/(timer2.read()-vrijeme);
                    timer2.reset();
                    timer2.start();
                    vrijeme=timer2.read();
                    /** Print the result in cm to the terminal with 1 decimal place
                    *  (number 5 after % means that total of 5 digits will be reserved
                    *  for printing the number, including the dot and one decimal place). */
     
                    if (brzina>=20) {
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("Daljina:%5.1f cm", distance);
                        lcd.locate(0,1);
                        lcd.printf("Brzina:%5.1f cm/s",brzina);
                        lcd.locate(0,2);
                        lcd.printf("Palim crveno!!!");
                        led3=0;
                        led2=1;
                        wait(3);
                        led2=0;
                        led1=1;
                        wait(10);
                        led2=1;
                        wait(4);
                        led3=1;
                        led1=0;
                        led2=0;
                    } else if (brzina < 20 && brzina >5) {
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("Daljina:%5.1f cm", distance);
                        lcd.locate(0,1);
                        lcd.printf("Brzina:%5.1f cm/s",brzina);
                        lcd.locate(0,2);
                        lcd.printf("Usporite!");
                        wait(2);
                    } else {
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("Daljina:%5.1f cm", distance);
                        lcd.locate(0,1);
                        lcd.printf("Brzina:%5.1f cm/s",brzina);
                        lcd.locate(0,2);
                        lcd.printf("OK");
                    }
                break;
                
                case(456):
                    lcd.cls();
                    lcd.locate(0,3);
                    lcd.printf(" %d", pass_code);
                break;

                case(789):
                    lcd.cls();
                    lcd.locate(0,3);
                    lcd.printf(" %d", pass_code);
                break;
            }
        
    }
}